/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.pdf;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetPropertyExpressionValueCommand;
import com.jaspersoft.studio.property.SetPropertyValueCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public abstract class APdfAction
extends CustomSelectionAction {
    public APdfAction(IWorkbenchPart part) {
        super(part, 2);
        this.initUI();
    }

    protected abstract Set<String> getPropertyNames();

    protected abstract Object getPropertyValue(String var1);

    protected abstract void initUI();

    public boolean isChecked() {
        this.ischecked = true;
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            this.ischecked = false;
        } else {
            block0: for (String attr : this.getPropertyNames()) {
                Object value = this.getPropertyValue(attr);
                for (Object element : graphicalElements) {
                    MGraphicElement model = (MGraphicElement)element;
                    JRPropertiesMap v = model.getPropertiesMap();
                    if (v == null) {
                        this.ischecked = false;
                        continue block0;
                    }
                    String oldValue = v.getProperty(attr);
                    if (oldValue != null && oldValue.equals(value)) continue;
                    this.ischecked = false;
                    continue block0;
                }
            }
        }
        return this.ischecked;
    }

    public List<Command> createCommands(MGraphicElement model) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        JRDesignElement el = model.getValue();
        JRPropertiesMap oldV = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
        JRPropertiesMap v = oldV != null ? oldV : new JRPropertiesMap();
        List oldPexp = model.getValue().getPropertyExpressionsList();
        for (String name : this.getPropertyNames()) {
            String oldPropValue = v.getProperty(name);
            JRPropertyExpression oldPExpValue = oldPexp.stream().filter(e -> e.getName().equals(name)).findFirst().orElse(null);
            Object value = this.getPropertyValue(name);
            if (value == null && oldPropValue == null && oldPExpValue == null) continue;
            if (value instanceof String) {
                if (oldPExpValue != null) {
                    cmds.add(new SetPropertyExpressionValueCommand(el, name, null));
                }
                if (value.equals(oldPropValue)) continue;
                cmds.add(new SetPropertyValueCommand(v, name, (String)value));
                continue;
            }
            if (value instanceof JRPropertyExpression) {
                if (oldPropValue != null) {
                    cmds.add(new SetPropertyValueCommand(v, name, null));
                }
                if (value.equals(oldPExpValue)) continue;
                cmds.add(new SetPropertyExpressionValueCommand(el, name, (JRPropertyExpression)value));
                continue;
            }
            if (oldPExpValue != null) {
                cmds.add(new SetPropertyExpressionValueCommand(el, name, null));
            }
            if (oldPropValue == null) continue;
            cmds.add(new SetPropertyValueCommand(v, name, null));
        }
        if (!cmds.isEmpty()) {
            SetValueCommand cmd = new SetValueCommand();
            cmd.setTarget(model);
            cmd.setPropertyId("PROPERTY_MAP");
            cmd.setPropertyValue(v);
            cmds.add(cmd);
        }
        return cmds;
    }

    @Override
    protected Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(this.getText(), null);
        for (Object element : graphicalElements) {
            MGraphicElement grModel = (MGraphicElement)element;
            command.setReferenceNodeIfNull(grModel);
            command.addAll(this.createCommands(grModel));
        }
        return command;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }
}

