/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.reportsplitting;

import com.jaspersoft.studio.editor.action.reportsplitting.ReportSplittingPropertyEditor;
import com.jaspersoft.studio.editor.action.reportsplitting.WReportSplittingPropertiesList;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.ui.BooleanComboPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TextPropertyDescription;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationTitleAreaDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;

public class ReportSplittingEditDialog
extends PersistentLocationTitleAreaDialog
implements IExpressionContextSetter {
    public static final String PART_NAME_PROPERTY = "net.sf.jasperreports.print.part.name";
    public static final String PART_SPLIT_PROPERTY = "net.sf.jasperreports.print.part.split";
    public static final String PART_VISIBLE_PROPERTY = "net.sf.jasperreports.print.part.visible";
    public static final String PART_PREFIX_PROPERTY = "net.sf.jasperreports.print.part.";
    private static final Point DEFAULT_DIALOG_SIZE = new Point(550, 550);
    private static final int REMOVE_ALL_ITEMS_ID = 2000;
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private static final String PROPERTY_PROPERTY_EXPRESSIONS = "propertyExpressions";
    private APropertyNode element;
    private ExpressionContext expContext;
    private PropertyExpressionsDTO propertiesDTO;
    private ReportSplittingPropertyEditor propertiesEditor;
    private WItemProperty partNameProperty;
    private WItemProperty partVisibleProperty;
    private WItemProperty enableSplitProperty;
    private WReportSplittingPropertiesList propertiesList;

    public ReportSplittingEditDialog(APropertyNode element, JasperReportsConfiguration jconfig, Shell parentShell) {
        super(parentShell);
        this.element = element;
        this.propertiesDTO = ((PropertyExpressionsDTO)element.getPropertyValue(PROPERTY_PROPERTY_EXPRESSIONS)).clone();
        this.propertiesEditor = new ReportSplittingPropertyEditor(this.propertiesDTO, jconfig);
        this.expContext = this.propertiesDTO.geteContext();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ReportSplittingEditDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ReportSplittingEditDialog_InnerTitle);
        this.setMessage(Messages.ReportSplittingEditDialog_InnerMessage, 1);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(area, 0);
        GridLayout mainGL = new GridLayout(2, false);
        main.setLayout((Layout)mainGL);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Label mcTitle = new Label(main, 0);
        mcTitle.setFont(ResourceManager.getBoldFont((Font)mcTitle.getFont()));
        mcTitle.setText(Messages.ReportSplittingEditDialog_EssentialInfoTitle);
        mcTitle.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label mcSeparator = new Label(main, 258);
        mcSeparator.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label partNameLbl = new Label(main, 0);
        partNameLbl.setText(Messages.ReportSplittingEditDialog_PartNamePropertyLbl);
        GridData partNameGD = new GridData(4, 128, false, false);
        partNameLbl.setLayoutData((Object)partNameGD);
        TextPropertyDescription partNameDesc = new TextPropertyDescription(PART_NAME_PROPERTY, Messages.ReportSplittingEditDialog_PartNamePropertyDesc, true);
        this.partNameProperty = new WItemProperty(main, 0, partNameDesc, this.propertiesEditor);
        this.partNameProperty.setLayoutData(new GridData(4, 4, true, false));
        this.partNameProperty.setExpressionContext(this.expContext);
        this.partNameProperty.updateWidget();
        Label partVisibleLbl = new Label(main, 0);
        partVisibleLbl.setText(Messages.ReportSplittingEditDialog_PartVisibleLbl);
        GridData partVisibleGD = new GridData(4, 128, false, false);
        partVisibleLbl.setLayoutData((Object)partVisibleGD);
        BooleanComboPropertyDescription partVisible = new BooleanComboPropertyDescription(PART_VISIBLE_PROPERTY, Messages.ReportSplittingEditDialog_PartVisibleLbl, Messages.ReportSplittingEditDialog_PartVisibleDesc, false, false, (String[][])new String[][]{{TRUE_VALUE, TRUE_VALUE}, {FALSE_VALUE, FALSE_VALUE}});
        partVisible.setFallbackValue(true);
        this.partVisibleProperty = new WItemProperty(main, 0, partVisible, this.propertiesEditor);
        this.partVisibleProperty.setLayoutData(new GridData(4, 4, true, false));
        this.partVisibleProperty.setExpressionContext(this.expContext);
        this.partVisibleProperty.updateWidget();
        Label enableSplitLbl = new Label(main, 0);
        enableSplitLbl.setText(Messages.ReportSplittingEditDialog_EnableSplitPropertyLbl);
        GridData enableSplitGD = new GridData(4, 128, false, false);
        enableSplitLbl.setLayoutData((Object)enableSplitGD);
        BooleanComboPropertyDescription enableSplitDesc = new BooleanComboPropertyDescription(PART_SPLIT_PROPERTY, Messages.ReportSplittingEditDialog_EnableSplitDescLbl, Messages.ReportSplittingEditDialog_EnableSplitDescDescription, false, false, (String[][])new String[][]{{TRUE_VALUE, TRUE_VALUE}, {FALSE_VALUE, FALSE_VALUE}});
        enableSplitDesc.setFallbackValue(false);
        this.enableSplitProperty = new WItemProperty(main, 0, enableSplitDesc, this.propertiesEditor);
        this.enableSplitProperty.setLayoutData(new GridData(4, 4, true, false));
        this.enableSplitProperty.setExpressionContext(this.expContext);
        this.enableSplitProperty.updateWidget();
        Label opTitle = new Label(main, 0);
        opTitle.setFont(ResourceManager.getBoldFont((Font)opTitle.getFont()));
        opTitle.setText(Messages.ReportSplittingEditDialog_AdditionalPropertiesTitle);
        opTitle.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label opSeparator = new Label(main, 258);
        opSeparator.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.propertiesList = new WReportSplittingPropertiesList(main, 0, this.propertiesEditor);
        this.propertiesList.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        Label closingSeparator = new Label(main, 258);
        closingSeparator.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        area.pack();
        area.layout();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2000, Messages.ReportSplittingEditDialog_ResetBtn, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.removeAllPropertiesPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        if (this.partNameProperty != null) {
            this.partNameProperty.setExpressionContext(expContext);
        }
        if (this.partVisibleProperty != null) {
            this.partVisibleProperty.setExpressionContext(expContext);
        }
        if (this.enableSplitProperty != null) {
            this.enableSplitProperty.setExpressionContext(expContext);
        }
    }

    protected Point getInitialSize() {
        return UIUtils.getScaledSize((Point)DEFAULT_DIALOG_SIZE);
    }

    protected boolean isResizable() {
        return true;
    }

    private void removeAllPropertiesPressed() {
        boolean answer = MessageDialog.openQuestion((Shell)this.getParentShell(), (String)Messages.ReportSplittingEditDialog_ResetDialogTitle, (String)Messages.ReportSplittingEditDialog_ResetDialogMsg);
        if (answer) {
            this.propertiesEditor.removeAllSplittingProperties();
            this.propertiesList.refreshList();
            this.partNameProperty.updateWidget();
            this.partVisibleProperty.updateWidget();
            this.enableSplitProperty.updateWidget();
        }
    }

    protected void okPressed() {
        this.element.setPropertyValue(PROPERTY_PROPERTY_EXPRESSIONS, this.propertiesDTO);
        super.okPressed();
    }
}

