/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.reportsplitting;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.GridDataUtil;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReportSplittingPropertyDialog
extends PersistentLocationDialog
implements IExpressionContextSetter {
    private static final Point DEFAULT_DIALOG_SIZE = new Point(450, 320);
    protected PropertyExpressionDTO splittingProperty;
    protected ExpressionContext expContext;
    protected boolean nameReadOnly;
    protected Text propertyName;
    protected Button useExpressionCheckbox;
    protected Text propertyValue;
    protected WTextExpression propertyValueExpression;
    protected Composite container;

    public ReportSplittingPropertyDialog(PropertyExpressionDTO property, boolean nameReadOnly, Shell shell) {
        super(shell);
        this.splittingProperty = property;
        this.nameReadOnly = nameReadOnly;
    }

    protected Control createDialogArea(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginHeight = 10;
        containerLayout.marginWidth = 10;
        containerLayout.verticalSpacing = 10;
        this.container.setLayout((Layout)containerLayout);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label infoMsgLbl = new Label(this.container, 64);
        infoMsgLbl.setText(NLS.bind((String)Messages.ReportSplittingPropertyDialog_InfoMsgText, (Object)"net.sf.jasperreports.print.part."));
        infoMsgLbl.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblPropertyName = new Label(this.container, 0);
        lblPropertyName.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblPropertyName.setText(Messages.ReportSplittingPropertyDialog_PropertyNameLbl);
        this.propertyName = new Text(this.container, 2048);
        GridData propertyNameGD = new GridData(4, 4, true, false);
        this.propertyName.setLayoutData((Object)propertyNameGD);
        this.propertyName.setEditable(!this.nameReadOnly);
        this.useExpressionCheckbox = new Button(this.container, 32);
        this.useExpressionCheckbox.setText(Messages.ReportSplittingPropertyDialog_UseExprCheckbox);
        this.useExpressionCheckbox.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblPropertyValue = new Label(this.container, 0);
        lblPropertyValue.setText(Messages.ReportSplittingPropertyDialog_PropertyValueLbl);
        lblPropertyValue.setLayoutData((Object)new GridData(4, 4, true, false));
        this.propertyValue = new Text(this.container, 2112);
        GridData propertyValueGD = new GridData(4, 4, true, true);
        propertyValueGD.heightHint = 50;
        this.propertyValue.setLayoutData((Object)propertyValueGD);
        this.propertyValueExpression = new WTextExpression(this.container, 0);
        GridData propertyValueExpressionGD = new GridData(4, 4, true, true);
        propertyValueExpressionGD.heightHint = 50;
        this.propertyValueExpression.setLayoutData(propertyValueExpressionGD);
        this.propertyValueExpression.setExpressionContext(this.expContext);
        this.container.pack();
        this.initWidgets();
        this.addListeners();
        return this.container;
    }

    private void initWidgets() {
        if (this.splittingProperty == null) {
            this.splittingProperty = new PropertyExpressionDTO(false, "", "", false);
        }
        if (this.splittingProperty.isExpression()) {
            this.useExpressionCheckbox.setSelection(true);
            this.propertyName.setText(Misc.nvl((String)this.getShortPropertyName()));
            this.propertyValueExpression.setExpression((JRDesignExpression)this.splittingProperty.getValueAsExpression());
            this.propertyValue.setVisible(false);
            this.propertyValue.setEnabled(false);
            ((GridData)this.propertyValue.getLayoutData()).exclude = true;
        } else {
            this.useExpressionCheckbox.setSelection(false);
            this.propertyName.setText(Misc.nvl((String)this.getShortPropertyName()));
            this.propertyValue.setText(Misc.nvl((String)this.splittingProperty.getValue()));
            this.propertyValueExpression.setVisible(false);
            this.propertyValueExpression.setEnabled(false);
            this.propertyValueExpression.setExpression(null);
            ((GridData)this.propertyValueExpression.getLayoutData()).exclude = true;
        }
    }

    protected String computeFullPropertyName(String visibleName) {
        return "net.sf.jasperreports.print.part." + visibleName;
    }

    protected String getShortPropertyName() {
        return this.splittingProperty.getName().replace("net.sf.jasperreports.print.part.", "");
    }

    private void addListeners() {
        this.propertyName.addModifyListener(e -> this.splittingProperty.setName(this.computeFullPropertyName(this.propertyName.getText())));
        this.propertyValue.addModifyListener(e -> {
            this.splittingProperty.setExpression(false);
            this.splittingProperty.setValue(this.propertyValue.getText());
        });
        this.propertyValueExpression.addModifyListener(event -> {
            this.splittingProperty.setExpression(true);
            String textValue = null;
            if (event.modifiedExpression != null) {
                textValue = event.modifiedExpression.getText();
            }
            this.splittingProperty.setValue(textValue);
        });
        this.useExpressionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReportSplittingPropertyDialog.this.useExpressionCheckbox.getSelection()) {
                    GridDataUtil.setGridDataExcludeAndVisibility((Control)ReportSplittingPropertyDialog.this.propertyValue, true);
                    GridDataUtil.setGridDataExcludeAndVisibility((Control)ReportSplittingPropertyDialog.this.propertyValueExpression, false);
                } else {
                    GridDataUtil.setGridDataExcludeAndVisibility((Control)ReportSplittingPropertyDialog.this.propertyValueExpression, true);
                    GridDataUtil.setGridDataExcludeAndVisibility((Control)ReportSplittingPropertyDialog.this.propertyValue, false);
                }
                ReportSplittingPropertyDialog.this.container.layout(new Control[]{ReportSplittingPropertyDialog.this.propertyValue, ReportSplittingPropertyDialog.this.propertyValueExpression});
            }
        });
    }

    protected Point getInitialSize() {
        return UIUtils.getScaledSize((Point)DEFAULT_DIALOG_SIZE);
    }

    protected boolean isResizable() {
        return true;
    }

    public PropertyExpressionDTO getModifiedSplittingProperty() {
        return this.splittingProperty;
    }

    protected void okPressed() {
        if (this.propertyName.getText().isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ReportSplittingPropertyDialog_ErrorTitle, (String)Messages.ReportSplittingPropertyDialog_ErrorEmptyMsg);
            return;
        }
        this.splittingProperty.setName(this.computeFullPropertyName(this.propertyName.getText()));
        if (this.useExpressionCheckbox.getSelection()) {
            this.splittingProperty.setExpression(true);
            this.splittingProperty.setValue(this.propertyValueExpression.getExpression().getText());
        } else {
            this.splittingProperty.setExpression(false);
            this.splittingProperty.setValue(this.propertyValue.getText());
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ReportSplittingPropertyDialog_Title);
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        if (this.propertyValueExpression != null) {
            this.propertyValueExpression.setExpressionContext(this.expContext);
        }
    }
}

