/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.reportsplitting;

import com.jaspersoft.studio.editor.action.reportsplitting.ReportSplittingPropertyDialog;
import com.jaspersoft.studio.editor.action.reportsplitting.ReportSplittingPropertyEditor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.swt.events.IRefreshableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class WReportSplittingPropertiesList
extends Composite
implements IRefreshableList,
IExpressionContextSetter {
    protected TableViewer tableViewerSplittingProperties;
    protected Button btnAddSplittingProperty;
    protected Button btnModifySplittingProperty;
    protected Button btnRemoveSplittingProperty;
    protected ReportSplittingPropertyEditor editor;
    protected ExpressionContext expContext;

    public WReportSplittingPropertiesList(Composite parent, int style, ReportSplittingPropertyEditor editor) {
        super(parent, style);
        this.editor = editor;
        GridLayout widgetGl = new GridLayout(2, false);
        this.setLayout((Layout)widgetGl);
        this.createWidgetContent();
    }

    private void createWidgetContent() {
        Composite cmpSplittingPropertiesTableViewer = new Composite((Composite)this, 0);
        cmpSplittingPropertiesTableViewer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        TableColumnLayout splittingPropertiesTableViewerTCL = new TableColumnLayout();
        cmpSplittingPropertiesTableViewer.setLayout((Layout)splittingPropertiesTableViewerTCL);
        this.tableViewerSplittingProperties = new TableViewer(cmpSplittingPropertiesTableViewer, 68100);
        Table table = this.tableViewerSplittingProperties.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tblclmnPropertyName = new TableViewerColumn(this.tableViewerSplittingProperties, 0);
        tblclmnPropertyName.getColumn().setText(this.getNameColumnLabel());
        tblclmnPropertyName.setLabelProvider((CellLabelProvider)this.getNameColumnLabelProvider());
        splittingPropertiesTableViewerTCL.setColumnData((Widget)tblclmnPropertyName.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        TableViewerColumn tblclmnExpression = new TableViewerColumn(this.tableViewerSplittingProperties, 0);
        tblclmnExpression.getColumn().setText(this.getValueColumnLabel());
        tblclmnExpression.setLabelProvider((CellLabelProvider)this.getValueColumnLabelProvider());
        splittingPropertiesTableViewerTCL.setColumnData((Widget)tblclmnExpression.getColumn(), (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        this.tableViewerSplittingProperties.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewerSplittingProperties.setInput(this.getFilteredProperties());
        this.tableViewerSplittingProperties.addDoubleClickListener(event -> {
            this.modifySelectedProperty();
            this.btnModifySplittingProperty.setEnabled(false);
            this.btnRemoveSplittingProperty.setEnabled(false);
        });
        this.tableViewerSplittingProperties.addSelectionChangedListener(event -> {
            this.btnModifySplittingProperty.setEnabled(true);
            this.btnRemoveSplittingProperty.setEnabled(true);
        });
        this.btnAddSplittingProperty = new Button((Composite)this, 0);
        this.btnAddSplittingProperty.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnAddSplittingProperty.setText(Messages.WReportSplittingPropertiesList_AddBtn);
        this.btnAddSplittingProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WReportSplittingPropertiesList.this.addNewProperty();
            }
        });
        this.btnModifySplittingProperty = new Button((Composite)this, 0);
        this.btnModifySplittingProperty.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnModifySplittingProperty.setText(Messages.WReportSplittingPropertiesList_ModifyBtn);
        this.btnModifySplittingProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WReportSplittingPropertiesList.this.modifySelectedProperty();
            }
        });
        this.btnRemoveSplittingProperty = new Button((Composite)this, 0);
        this.btnRemoveSplittingProperty.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnRemoveSplittingProperty.setText(Messages.WReportSplittingPropertiesList_RemoveBtn);
        this.btnRemoveSplittingProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WReportSplittingPropertiesList.this.removeSelectedProperty();
            }
        });
        this.enableDefaultButtons();
    }

    protected ColumnLabelProvider getNameColumnLabelProvider() {
        return new SplittingPropertyNameLabelProvider();
    }

    protected ColumnLabelProvider getValueColumnLabelProvider() {
        return new SplittingPropertyValueLabelProvider();
    }

    protected String getNameColumnLabel() {
        return Messages.WReportSplittingPropertiesList_NameCol;
    }

    protected String getValueColumnLabel() {
        return Messages.WReportSplittingPropertiesList_ValueCol;
    }

    protected List<PropertyExpressionDTO> getFilteredProperties() {
        ArrayList<PropertyExpressionDTO> properties = new ArrayList<PropertyExpressionDTO>();
        for (PropertyExpressionDTO p : this.editor.getAllProperties()) {
            String name = p.getName();
            if (name.equals("net.sf.jasperreports.print.part.name") || name.equals("net.sf.jasperreports.print.part.split") || name.equals("net.sf.jasperreports.print.part.visible") || !name.startsWith("net.sf.jasperreports.print.part.")) continue;
            properties.add(p);
        }
        properties.sort(new Comparator<PropertyExpressionDTO>(){

            @Override
            public int compare(PropertyExpressionDTO p1, PropertyExpressionDTO p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        return properties;
    }

    private void removeSelectedProperty() {
        Object selected = ((IStructuredSelection)this.tableViewerSplittingProperties.getSelection()).getFirstElement();
        if (selected instanceof PropertyExpressionDTO) {
            this.editor.removeProperty(((PropertyExpressionDTO)selected).getName());
            this.refreshList();
        }
        this.enableDefaultButtons();
    }

    private void modifySelectedProperty() {
        Object selected = ((IStructuredSelection)this.tableViewerSplittingProperties.getSelection()).getFirstElement();
        if (selected instanceof PropertyExpressionDTO) {
            PropertyExpressionDTO propertyCopy = ((PropertyExpressionDTO)selected).clone();
            ReportSplittingPropertyDialog editDialog = this.getPropertyDialog(propertyCopy, false, this.getShell());
            editDialog.setExpressionContext(this.expContext);
            if (editDialog.open() == 0) {
                PropertyExpressionDTO editedProperty = editDialog.getModifiedSplittingProperty();
                String originalPname = ((PropertyExpressionDTO)selected).getName();
                if (!editedProperty.getName().equals(originalPname) && this.editor.getProperty(editedProperty.getName()) != null) {
                    this.showEditErrorMessage();
                } else {
                    this.editor.removeProperty(((PropertyExpressionDTO)selected).getName());
                    this.editor.addProperty(editedProperty);
                    this.refreshList();
                }
            }
        }
        this.enableDefaultButtons();
    }

    protected ReportSplittingPropertyDialog getPropertyDialog(PropertyExpressionDTO property, boolean nameReadOnly, Shell shell) {
        return new ReportSplittingPropertyDialog(property, nameReadOnly, shell);
    }

    protected void showEditErrorMessage() {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.WReportSplittingPropertiesList_EditErrorTitle, (String)Messages.WReportSplittingPropertiesList_EditErrorMsg);
    }

    private void addNewProperty() {
        ReportSplittingPropertyDialog editDialog = this.getPropertyDialog(null, false, this.getShell());
        editDialog.setExpressionContext(this.expContext);
        if (editDialog.open() == 0) {
            PropertyExpressionDTO editedProperty = editDialog.getModifiedSplittingProperty();
            PropertyExpressionDTO existingProp = this.editor.getProperty(editedProperty.getName());
            if (existingProp != null) {
                this.showAddErrorMessage();
            } else {
                this.editor.addProperty(editedProperty);
                this.refreshList();
            }
        }
        this.enableDefaultButtons();
    }

    protected void showAddErrorMessage() {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.WReportSplittingPropertiesList_AddErrorTitle, (String)Messages.WReportSplittingPropertiesList_AddErrorMsg);
    }

    private void enableDefaultButtons() {
        this.btnAddSplittingProperty.setEnabled(true);
        this.btnModifySplittingProperty.setEnabled(false);
        this.btnRemoveSplittingProperty.setEnabled(false);
    }

    @Override
    public void refreshList() {
        this.tableViewerSplittingProperties.setInput(this.getFilteredProperties());
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    private class SplittingPropertyNameLabelProvider
    extends ColumnLabelProvider {
        private SplittingPropertyNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PropertyExpressionDTO) {
                return ((PropertyExpressionDTO)element).getName();
            }
            return super.getText(element);
        }
    }

    private class SplittingPropertyValueLabelProvider
    extends ColumnLabelProvider {
        private SplittingPropertyValueLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PropertyExpressionDTO) {
                PropertyExpressionDTO p = (PropertyExpressionDTO)element;
                return Misc.nvl((String)p.getValue());
            }
            return super.getText(element);
        }
    }
}

