/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.size;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.ToolUtilitiesCompatibility;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class MatchSizeAction
extends ACachedSelectionAction
implements IGlobalAction {
    private TYPE resizeType;
    public static final String ID_SIZE_WIDTH = "size_WIDTH";
    public static final String ID_SIZE_HEIGHT = "size_HEIGHT";
    public static final String ID_SIZE_BOTH = "size_BOTH";

    public MatchSizeAction(IWorkbenchPart part, TYPE type) {
        super(part);
        this.resizeType = type;
        this.initUI();
    }

    @Override
    protected Command createCommand() {
        List<Object> editparts = this.editor.getSelectionCache().getSelectionModelPartForType(MGraphicElement.class);
        editparts = ToolUtilitiesCompatibility.getSelectionWithoutDependants(editparts);
        EditPart primary = this.getPrimary(editparts);
        if (editparts.size() < 2 || primary == null) {
            return null;
        }
        MGraphicElement primaryModel = (MGraphicElement)primary.getModel();
        JRDesignElement primaryElement = primaryModel.getValue();
        JSSCompoundCommand command = new JSSCompoundCommand(primaryModel);
        command.setDebugLabel(this.getText());
        switch (this.resizeType) {
            case WIDTH: {
                for (EditPart editPart : editparts) {
                    APropertyNode model = (APropertyNode)editPart.getModel();
                    command.add(this.createCommand("width", model, primaryElement.getWidth()));
                }
                break;
            }
            case HEIGHT: {
                for (EditPart editPart : editparts) {
                    APropertyNode model = (APropertyNode)editPart.getModel();
                    command.add(this.createCommand("height", model, primaryElement.getHeight()));
                }
                break;
            }
            case BOTH: {
                for (EditPart editPart : editparts) {
                    APropertyNode model = (APropertyNode)editPart.getModel();
                    command.add(this.createCommand("width", model, primaryElement.getWidth()));
                    command.add(this.createCommand("height", model, primaryElement.getHeight()));
                }
                break;
            }
        }
        return command;
    }

    protected EditPart getPrimary(List<EditPart> editparts) {
        EditPart partialResult = null;
        for (EditPart part : editparts) {
            if (part.getModel() instanceof MGraphicElement && (partialResult = part).getSelected() == 2) break;
        }
        return partialResult;
    }

    private SetValueCommand createCommand(String property, APropertyNode destination, Object value) {
        SetValueCommand newCommand = new SetValueCommand();
        newCommand.setTarget(destination);
        newCommand.setPropertyValue(value);
        newCommand.setPropertyId(property);
        return newCommand;
    }

    protected void initUI() {
        switch (this.resizeType) {
            case WIDTH: {
                this.setId(ID_SIZE_WIDTH);
                this.setText(Messages.MatchSizeAction_widthText);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/matchwidth.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/matchwidth_d.gif"));
                this.setToolTipText(Messages.MatchSizeAction_widthTooltip);
                break;
            }
            case HEIGHT: {
                this.setId(ID_SIZE_HEIGHT);
                this.setText(Messages.MatchSizeAction_heightText);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/matchheight.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/matchheight_d.gif"));
                this.setToolTipText(Messages.MatchSizeAction_heightTooltip);
                break;
            }
            case BOTH: {
                this.setId(ID_SIZE_BOTH);
                this.setText(Messages.MatchSizeAction_match_size);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/match-size.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/match-size.gif"));
                this.setToolTipText(Messages.MatchSizeAction_match_size_tool_tip);
            }
        }
    }

    public static enum TYPE {
        WIDTH,
        HEIGHT,
        BOTH;

    }
}

