/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.xls;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.editor.action.pdf.PropertiesList;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class XLSAction
extends CustomSelectionAction {
    public static String FIT_COL_ID = "net.sf.jasperreports.export.xls.auto.fit.column";
    public static String FIT_ROW_ID = "net.sf.jasperreports.export.xls.auto.fit.row";
    public static String BREAK_AFTER_ROW_ID = "net.sf.jasperreports.export.xls.break.after.row";
    public static String BREAK_BEFORE_ROW_ID = "net.sf.jasperreports.export.xls.break.before.row";
    public static String CELL_HIDDEN_ID = "net.sf.jasperreports.export.xls.cell.hidden";
    public static String CELL_LOCKED_ID = "net.sf.jasperreports.export.xls.cell.locked";
    public static String AUTOFILTER_ID = "net.sf.jasperreports.export.xls.auto.filter";
    public static String FREEZE_ROW_ID = "net.sf.jasperreports.export.xls.freeze.row.edge";
    public static String FREEZE_COL_ID = "net.sf.jasperreports.export.xls.freeze.column.edge";
    private String value;
    private String attributeId;
    private String[] attributeToRemove;

    public XLSAction(IWorkbenchPart part, String actionId, String value, String actionName) {
        this(part, actionId, actionId, value, actionName);
    }

    public XLSAction(IWorkbenchPart part, String actionId, String attributeId, String value, String actionName) {
        super(part, 2);
        this.setId(actionId);
        this.attributeId = attributeId;
        this.value = value;
        PropertiesList.addItem(actionId);
        this.setText(actionName);
        this.attributeToRemove = null;
    }

    public XLSAction(IWorkbenchPart part, String actionId, String attributeId, String value, String actionName, String[] attributeToRemove) {
        this(part, actionId, actionId, value, actionName);
        this.attributeToRemove = attributeToRemove;
    }

    public boolean isChecked() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return false;
        }
        for (Object element : graphicalElements) {
            MGraphicElement model = (MGraphicElement)element;
            JRPropertiesMap v = model.getPropertiesMap();
            if (v == null) {
                return false;
            }
            String oldValue = v.getProperty(this.attributeId);
            if (oldValue != null && oldValue.equals(this.value)) continue;
            return false;
        }
        return true;
    }

    private void removeAttributes(JRPropertiesMap map) {
        if (this.attributeToRemove != null) {
            String[] stringArray = this.attributeToRemove;
            int n = this.attributeToRemove.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                map.removeProperty(attributeName);
                ++n2;
            }
        }
    }

    public Command createCommand(MGraphicElement model) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(model);
        cmd.setPropertyId("PROPERTY_MAP");
        JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
        String oldValue = null;
        if (v == null) {
            v = new JRPropertiesMap();
        } else {
            oldValue = v.getProperty(this.attributeId);
            v.removeProperty(this.attributeId);
        }
        if (this.value != null && !this.value.equals(oldValue)) {
            v.setProperty(this.attributeId, this.value);
            this.removeAttributes(v);
        }
        cmd.setPropertyValue(v);
        return cmd;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    @Override
    protected Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        command.setDebugLabel(this.getText());
        for (Object element : graphicalElements) {
            MGraphicElement graphElement = (MGraphicElement)element;
            command.add(this.createCommand(graphElement));
            command.setReferenceNodeIfNull(graphElement);
        }
        this.freshChecked = false;
        return command;
    }
}

