/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.defaults;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.editor.defaults.DefaultNewWizard;
import com.jaspersoft.studio.editor.defaults.JrxmlFilterDialog;
import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wb.swt.ResourceManager;

public class HandleDefaultsAction
extends Action
implements IMenuCreator {
    public static final String ID = "HandleDefaultsAction";
    private List<String> values;
    private boolean refreshItemList = true;
    private Menu menu;
    private SelectionAdapter deleteTemplateSet = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object data = e.widget.getData();
            if (data != null) {
                String resourceName = HandleDefaultsAction.this.getItemText(data.toString());
                String message = MessageFormat.format(Messages.HandleDefaultsAction_deleteMessage, resourceName);
                MessageDialog dialog = new MessageDialog(UIUtils.getShell(), Messages.HandleDefaultsAction_deleteTitle, null, message, 3, new String[]{Messages.HandleDefaultsAction_delteMenu, Messages.HandleDefaultsAction_deleteAll, Messages.HandleDefaultsAction_Abort}, 2);
                int result = dialog.open();
                if (result == 0 || result == 1) {
                    DefaultManager.INSTANCE.removeDefaultFile(data.toString());
                }
                if (result == 1) {
                    Path path = new Path(data.toString());
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IFile reportFile = workspace.getRoot().getFileForLocation((IPath)path);
                    if (reportFile.exists()) {
                        try {
                            reportFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }
    };
    private SelectionAdapter editTemplateSet = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            final Object data = e.widget.getData();
            if (data != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            Path path = new Path(data.toString());
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IFile reportFile = workspace.getRoot().getFileForLocation((IPath)path);
                            if (reportFile.exists()) {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)reportFile, (boolean)true);
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    };
    private SelectionAdapter useTemplateSet = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object data = e.widget.getData();
            if (data != null) {
                HandleDefaultsAction.this.refreshItemList = true;
                DefaultManager.INSTANCE.setDefaultFile(data.toString());
            }
        }
    };
    private SelectionAdapter importTemplateSet = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            JrxmlFilterDialog filterDialog = new JrxmlFilterDialog(UIUtils.getShell(), false);
            if (filterDialog.open() == 0) {
                Object[] objectArray = filterDialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object result = objectArray[n2];
                    IFile file = (IFile)result;
                    DefaultManager.INSTANCE.addDefaultFile(file.getRawLocation().toOSString(), false);
                    ++n2;
                }
                HandleDefaultsAction.this.refreshItemList = true;
            }
        }
    };
    private SelectionAdapter createTemplateSet = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DefaultNewWizard newWizard = new DefaultNewWizard();
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)newWizard);
            if (dialog.open() == 0) {
                IFile templateFile = newWizard.getReportFile();
                String templatePath = templateFile.getRawLocation().makeAbsolute().toOSString();
                DefaultManager.INSTANCE.addDefaultFile(templatePath, false);
                HandleDefaultsAction.this.createMenuElement(templatePath, false);
                HandleDefaultsAction.this.refreshItemList = true;
            }
        }
    };
    private SelectionAdapter deselectTemplateSet = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DefaultManager.INSTANCE.unsetDefaultFile();
            HandleDefaultsAction.this.refreshItemList = true;
        }
    };

    public HandleDefaultsAction() {
        this.setText(Messages.HandleDefaultsAction_actionText);
        this.setMenuCreator(this);
        this.setId(ID);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        Menu rootMenu = new Menu(parent);
        this.getMenu(rootMenu);
        this.menu = rootMenu;
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        MenuItem root = new MenuItem(parent, 64);
        this.menu = new Menu(parent);
        root.setMenu(this.menu);
        root.setText(Messages.HandleDefaultsAction_menuTitle);
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (HandleDefaultsAction.this.refreshItemList || HandleDefaultsAction.this.menu.getItemCount() == 0 || !DefaultManager.INSTANCE.getAvailableElements().equals(HandleDefaultsAction.this.values)) {
                    MenuItem[] menuItemArray = HandleDefaultsAction.this.menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    HandleDefaultsAction.this.initilizeItems();
                    HandleDefaultsAction.this.refreshItemList = false;
                }
            }
        });
        return this.menu;
    }

    private String getItemText(String fileName) {
        File currentFile = new File(fileName);
        return currentFile.getName();
    }

    private void initilizeItems() {
        this.createDefaultElements();
        this.values = DefaultManager.INSTANCE.getAvailableElements();
        if (this.values.size() > 0) {
            MenuItem item = new MenuItem(this.menu, 32);
            item.setText(Messages.HandleDefaultsAction_unsetTemplate);
            item.addSelectionListener((SelectionListener)this.deselectTemplateSet);
        }
        for (String fileName : this.values) {
            boolean isDefault = DefaultManager.INSTANCE.isCurrentDefault(fileName);
            this.createMenuElement(fileName, isDefault);
        }
    }

    private void createDefaultElements() {
        MenuItem item = new MenuItem(this.menu, 32);
        item.setText(Messages.HandleDefaultsAction_createTemplate);
        item.addSelectionListener((SelectionListener)this.createTemplateSet);
        item = new MenuItem(this.menu, 32);
        item.setText(Messages.HandleDefaultsAction_importTemplate);
        item.addSelectionListener((SelectionListener)this.importTemplateSet);
        if (DefaultManager.INSTANCE.getAvailableElements().size() > 0) {
            new MenuItem(this.menu, 2);
        }
    }

    private void createMenuElement(String fileName, boolean isSelected) {
        Menu itemSubmenu = new Menu(this.menu);
        MenuItem item = new MenuItem(this.menu, 64);
        item.setMenu(itemSubmenu);
        String itemName = this.getItemText(fileName);
        if (isSelected) {
            item.setImage(ResourceManager.getImage((ImageDescriptor)JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/check-16.png")));
            itemName = String.valueOf(itemName) + Messages.HandleDefaultsAction_actualTemplateTag;
        }
        item.setText(itemName);
        item.setData((Object)fileName);
        this.createMenuElementSubmenu(fileName, itemSubmenu, isSelected);
    }

    private void createMenuElementSubmenu(String fileName, Menu itemSubmenu, boolean isSelected) {
        if (!isSelected) {
            MenuItem selectDefault = new MenuItem(itemSubmenu, 0);
            selectDefault.setText(Messages.HandleDefaultsAction_useTemplate);
            selectDefault.setData((Object)fileName);
            selectDefault.addSelectionListener((SelectionListener)this.useTemplateSet);
        }
        MenuItem openForEdit = new MenuItem(itemSubmenu, 0);
        openForEdit.setText(Messages.HandleDefaultsAction_editTemplate);
        openForEdit.setData((Object)fileName);
        openForEdit.addSelectionListener((SelectionListener)this.editTemplateSet);
        MenuItem delete = new MenuItem(itemSubmenu, 0);
        delete.setText(Messages.HandleDefaultsAction_deleteTemplate);
        delete.setData((Object)fileName);
        delete.addSelectionListener((SelectionListener)this.deleteTemplateSet);
    }
}

