/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.defaults;

import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.editor.defaults.DefaultNewWizard;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import java.text.MessageFormat;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.util.StyleResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class SetDefaultsAction
extends ACachedSelectionAction {
    public static final String ID = "SetDefaultElementAction";
    private MGraphicElement element;

    public SetDefaultsAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        super.init();
        this.setText(Messages.SetDefaultsAction_text);
        this.setToolTipText(Messages.SetDefaultsAction_tooltip);
        this.setId(ID);
        this.setEnabled(false);
    }

    @Override
    public void run() {
        if (DefaultManager.INSTANCE.hasDefault()) {
            String message = MessageFormat.format(Messages.SetDefaultsAction_message1, DefaultManager.INSTANCE.getDefaultName());
            CheckboxMessageDialog dialog = new CheckboxMessageDialog(UIUtils.getShell(), Messages.SetDefaultsAction_messageTitle, null, message, 3, new String[]{Messages.common_yes, Messages.common_no}, 1);
            if (dialog.open() == 0) {
                DefaultManager.INSTANCE.addElementToCurrentDefault(this.element, dialog.isGetFromStyles());
            }
        } else {
            CheckboxMessageDialog dialog = new CheckboxMessageDialog(UIUtils.getShell(), Messages.SetDefaultsAction_messageTitle, null, Messages.SetDefaultsAction_message2, 3, new String[]{Messages.common_yes, Messages.common_no}, 1);
            if (dialog.open() == 0) {
                DefaultNewWizard newWizard = new DefaultNewWizard();
                WizardDialog newDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)newWizard);
                if (newDialog.open() == 0) {
                    IFile templateFile = newWizard.getReportFile();
                    String templatePath = templateFile.getRawLocation().makeAbsolute().toOSString();
                    DefaultManager.INSTANCE.addDefaultFile(templatePath, true);
                    DefaultManager.INSTANCE.addElementToCurrentDefault(this.element, dialog.isGetFromStyles());
                }
            }
        }
    }

    @Override
    protected boolean calculateEnabled() {
        List<Object> elements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (elements.size() == 1) {
            this.element = (MGraphicElement)elements.get(0);
            return true;
        }
        this.element = null;
        return false;
    }

    private class CheckboxMessageDialog
    extends MessageDialog {
        private boolean getFromStyles;

        public CheckboxMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.getFromStyles = false;
        }

        protected Control createCustomArea(Composite parent) {
            if (SetDefaultsAction.this.element != null && StyleResolver.getInstance().getBaseStyle((JRStyleContainer)SetDefaultsAction.this.element.getValue()) != null) {
                Composite container = new Composite(parent, 0);
                container.setLayout((Layout)new GridLayout(1, false));
                final Button checkButton = new Button(container, 32);
                checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CheckboxMessageDialog.this.getFromStyles = checkButton.getSelection();
                    }
                });
                checkButton.setText(Messages.SetDefaultsAction_exportStyleCheckbox);
                return container;
            }
            return null;
        }

        public boolean isGetFromStyles() {
            return this.getFromStyles;
        }
    }
}

