/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.commands;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class AlignCommand
extends Command {
    private int alignement;
    private Dimension parent;
    private JRDesignElement jrElement;
    private int oldX;
    private int oldY;

    public AlignCommand(int alignement, EditPart editPart) {
        this(alignement, (MGraphicElement)editPart.getModel());
    }

    public AlignCommand(int alignement, MGraphicElement m) {
        this.alignement = alignement;
        this.jrElement = m.getValue();
        ANode n = m.getParent();
        if (n instanceof IContainer) {
            if (n instanceof MBand) {
                int h = ((MBand)n).getValue().getHeight();
                JasperDesign jasperDesign = m.getJasperDesign();
                int w = jasperDesign.getPageWidth() - jasperDesign.getLeftMargin() - jasperDesign.getRightMargin();
                this.parent = new Dimension(w, h);
            } else if (n instanceof IGraphicElementContainer) {
                this.parent = ((IGraphicElementContainer)((Object)n)).getSize();
            }
        }
    }

    public void execute() {
        this.oldX = this.jrElement.getX();
        this.oldY = this.jrElement.getY();
        int newX = this.oldX;
        int newY = this.oldY;
        switch (this.alignement) {
            case 1: {
                newX = 0;
                break;
            }
            case 4: {
                newX = this.parent.width - this.jrElement.getWidth();
                break;
            }
            case 8: {
                newY = 0;
                break;
            }
            case 32: {
                newY = this.parent.height - this.jrElement.getHeight();
                break;
            }
            case 2: {
                newX = this.parent.width / 2 - this.jrElement.getWidth() / 2;
                break;
            }
            case 16: {
                newY = this.parent.height / 2 - this.jrElement.getHeight() / 2;
            }
        }
        this.jrElement.setX(newX);
        this.jrElement.setY(newY);
    }

    public void undo() {
        this.jrElement.setX(this.oldX);
        this.jrElement.setY(this.oldY);
    }
}

