/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.commands;

import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGraphicElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetPositionCommand
extends Command {
    protected Rectangle newBounds;
    protected Rectangle oldBounds;
    protected JRDesignElement jrElement;
    protected Rectangle parentBounds;
    protected ANode child;

    public void setContext(ANode child, Rectangle constraint) {
        this.child = child;
        if (child.getValue() instanceof JRDesignElement) {
            this.jrElement = (JRDesignElement)child.getValue();
            this.newBounds = constraint;
            this.parentBounds = ((IGraphicElement)((Object)child)).getBounds();
        }
    }

    public void execute() {
        if (this.jrElement != null) {
            this.oldBounds = new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight());
            int y = this.jrElement.getY() + this.newBounds.y - this.parentBounds.y;
            int x = this.jrElement.getX() + this.newBounds.x - this.parentBounds.x;
            this.jrElement.setX(x);
            this.jrElement.setY(y);
            this.jrElement.setWidth(this.newBounds.width);
            this.jrElement.setHeight(this.newBounds.height);
            this.layoutChildAndParent();
        }
    }

    public void undo() {
        if (this.jrElement != null) {
            this.jrElement.setWidth(this.oldBounds.width);
            this.jrElement.setHeight(this.oldBounds.height);
            this.jrElement.setX(this.oldBounds.x);
            this.jrElement.setY(this.oldBounds.y);
            this.layoutChildAndParent();
        }
    }

    public String getLabel() {
        if (this.oldBounds != null && (this.oldBounds.x != this.newBounds.x || this.oldBounds.y != this.newBounds.y)) {
            return "set location";
        }
        return "resize";
    }

    protected void layoutChildAndParent() {
        LayoutManager.layoutContainer(this.child);
        LayoutManager.layoutContainer(this.child.getParent());
    }

    public boolean canExecute() {
        return this.isOperationAllowed(this.oldBounds, this.newBounds);
    }

    protected boolean isOperationAllowed(Rectangle oldBounds, Rectangle newBounds) {
        String parentLayout;
        JRPropertiesMap newMap = LayoutManager.getPropertyMap(this.child.getParent());
        if (newMap != null && (parentLayout = newMap.getProperty("com.jaspersoft.studio.layout")) != null) {
            ILayout layout = LayoutManager.getLayout(parentLayout);
            return layout.allowChildBoundChange(this.child, oldBounds, newBounds);
        }
        return true;
    }
}

