/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.csv;

import com.jaspersoft.studio.editor.action.csv.CSVAction;
import com.jaspersoft.studio.editor.gef.decorator.chainable.AbstractPainter;
import com.jaspersoft.studio.editor.gef.decorator.chainable.IDecoratorInterface;
import com.jaspersoft.studio.editor.gef.decorator.text.TextLocation;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRPropertiesMap;

public class CSVDecorator
implements IDecoratorInterface {
    private static ImageIcon startImageAwt = null;
    private static ImageIcon endImageAwt = null;
    private static Font JSS_TEXT_FONT = new Font("SansSerif", 0, 10);
    private static Color JSS_TEXT_COLOR = new Color(29, 198, 29);
    String[] tags;

    public CSVDecorator() {
        if (startImageAwt == null || endImageAwt == null) {
            startImageAwt = new ImageIcon(CSVDecorator.class.getResource("/icons/resources/corner1.png"));
            endImageAwt = new ImageIcon(CSVDecorator.class.getResource("/icons/resources/corner2.png"));
        }
        this.tags = new String[]{CSVAction.COL_NAME, "isCol ", CSVAction.COL_DATA, "isCol ", CSVAction.FIELD_DELIMITER, "isFieldDelimiter", CSVAction.RECORD_DELIMITER, "isRecordDelimiter"};
    }

    public void setTextFont(Font newFont) {
        JSS_TEXT_FONT = newFont;
    }

    public void setTextColor(Color newColor) {
        JSS_TEXT_COLOR = newColor;
    }

    @Override
    public ArrayList<AbstractPainter> getDecoratorPainter(ComponentFigure fig) {
        JRPropertiesMap mapProperties = fig.getJrElement().getPropertiesMap();
        ArrayList<AbstractPainter> result = new ArrayList<AbstractPainter>();
        boolean hasValue = false;
        String endString = "";
        int i = 0;
        while (i < this.tags.length) {
            String prop = this.tags[i];
            String label = this.tags[i + 1];
            hasValue = mapProperties.containsProperty(prop);
            if (prop.equals(CSVAction.COL_DATA) && hasValue) {
                endString = String.valueOf(endString) + label.concat(mapProperties.getProperty(CSVAction.COL_NAME)).concat(" ");
            }
            if (prop.equals(CSVAction.COL_NAME) && hasValue && !mapProperties.containsProperty(CSVAction.COL_DATA)) {
                endString = String.valueOf(endString) + label.concat(mapProperties.getProperty(CSVAction.COL_NAME)).concat(" ");
            }
            i += 2;
        }
        if ((endString = endString.trim()).length() > 0) {
            result.add(new TextLocation(AbstractPainter.Location.BottomRight, endString, JSS_TEXT_FONT, JSS_TEXT_COLOR));
        }
        return result;
    }
}

