/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.csv;

import com.jaspersoft.studio.editor.gef.decorator.csv.NameComboDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ColumnNamesSettingDialog
extends PersistentLocationDialog {
    private List<String> columnNames;
    private JasperDesign jd;
    private List<JRDesignElement> tels;

    public ColumnNamesSettingDialog(Shell parentShell, JasperDesign jd) {
        super(parentShell);
        String names;
        this.jd = jd;
        String[] cols = new String[]{};
        JRPropertiesMap map = jd.getPropertiesMap();
        if (map != null && !Misc.isNullOrEmpty((String)(names = map.getProperty("net.sf.jasperreports.export.csv.column.names")))) {
            cols = names.split(",");
        }
        this.columnNames = new ArrayList<String>(Arrays.asList(cols));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        TableViewer viewer = new TableViewer(container, 68356);
        this.createColumns(viewer);
        Table table = viewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput(this.columnNames);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 5;
        gd.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gd);
        Composite cmp = new Composite(container, 0);
        cmp.setLayout((Layout)new GridLayout());
        gd = new GridData(2);
        gd.widthHint = 80;
        cmp.setLayoutData((Object)gd);
        new NewButton().createNewButtons(cmp, viewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                if (ColumnNamesSettingDialog.this.tels == null) {
                    ColumnNamesSettingDialog.this.tels = new ArrayList<JRDesignElement>();
                    List<JRDesignElement> els = ModelUtils.getAllGElements(ColumnNamesSettingDialog.this.jd);
                    for (JRDesignElement de : els) {
                        if (!(de instanceof JRTextElement) || de.getPropertiesMap() == null || !de.getPropertiesMap().containsProperty("net.sf.jasperreports.export.csv.column.name")) continue;
                        ColumnNamesSettingDialog.this.tels.add(de);
                    }
                }
                ArrayList<String> newNames = new ArrayList<String>();
                for (JRDesignElement te : ColumnNamesSettingDialog.this.tels) {
                    String name;
                    JRPropertiesMap map = te.getPropertiesMap();
                    if (map == null || (name = map.getProperty("net.sf.jasperreports.export.csv.column.name")) == null) continue;
                    boolean exists = false;
                    for (String key : ColumnNamesSettingDialog.this.columnNames) {
                        if (!name.equals(key)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    newNames.add(name);
                }
                if (!newNames.isEmpty()) {
                    NameComboDialog dialog = new NameComboDialog(UIUtils.getShell(), newNames);
                    if (dialog.open() == 0) {
                        return dialog.getName();
                    }
                } else {
                    UIUtils.showWarning((String)Messages.ColumnNamesSettingDialog_1);
                }
                return null;
            }
        });
        new ListOrderButtons().createOrderButtons(cmp, viewer);
        new DeleteButton().createDeleteButton(cmp, viewer);
        return area;
    }

    private void createColumns(TableViewer viewer) {
        TableViewerColumn colFirstName = new TableViewerColumn(viewer, 0);
        colFirstName.getColumn().setWidth(200);
        colFirstName.getColumn().setText(Messages.ColumnNamesSettingDialog_2);
        colFirstName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
    }

    public String getColumnNames() {
        String r = "";
        String sep = "";
        for (String item : this.columnNames) {
            r = String.valueOf(r) + sep + item;
            sep = ",";
        }
        return r;
    }

    protected String getDialogTitle() {
        return Messages.ColumnNamesSettingDialog_Title;
    }
}

