/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures.borders;

import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.java2d.J2DUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;

public class SimpleShadowBorder
extends AbstractBorder {
    public Insets getInsets(IFigure figure) {
        return new Insets(ReportPageFigure.PAGE_BORDER.top);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle bounds = figure.getBounds();
        if (figure instanceof HandleBounds) {
            bounds = ((HandleBounds)figure).getHandleBounds();
        }
        this.paintShadowBorder(graphics, bounds.x - insets.left, bounds.y - insets.top, bounds.width + insets.right + insets.left, bounds.height + insets.top + insets.bottom);
    }

    private void paintShadowBorder(Graphics graphics, int x, int y, int width, int height) {
        Graphics2D g = ComponentFigure.getG2D(graphics);
        if (g != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(J2DUtils.getInvertedZoomedStroke(oldStroke, graphics.getAbsoluteScale()));
            g.setBackground(Color.lightGray);
            g.setColor(Color.lightGray);
            int sOffset = 5;
            g.fillRect(x + ReportPageFigure.PAGE_BORDER.left + sOffset, y + height - ReportPageFigure.PAGE_BORDER.bottom, width - (ReportPageFigure.PAGE_BORDER.left + ReportPageFigure.PAGE_BORDER.left), sOffset);
            g.fillRect(x + width - ReportPageFigure.PAGE_BORDER.right, y + ReportPageFigure.PAGE_BORDER.top + sOffset, sOffset, height - ReportPageFigure.PAGE_BORDER.bottom - ReportPageFigure.PAGE_BORDER.top);
            g.setBackground(Color.black);
            g.setColor(Color.black);
            g.drawLine(x + ReportPageFigure.PAGE_BORDER.left, y + ReportPageFigure.PAGE_BORDER.top, x + width - ReportPageFigure.PAGE_BORDER.right, y + ReportPageFigure.PAGE_BORDER.top);
            g.drawLine(x + ReportPageFigure.PAGE_BORDER.left, y + height - ReportPageFigure.PAGE_BORDER.bottom, x + width - ReportPageFigure.PAGE_BORDER.right, y + height - ReportPageFigure.PAGE_BORDER.top);
            g.drawLine(x + ReportPageFigure.PAGE_BORDER.left, y + ReportPageFigure.PAGE_BORDER.top, x + ReportPageFigure.PAGE_BORDER.left, y + height - ReportPageFigure.PAGE_BORDER.top);
            g.drawLine(x + width - ReportPageFigure.PAGE_BORDER.right, y + ReportPageFigure.PAGE_BORDER.top, x + width - ReportPageFigure.PAGE_BORDER.right, y + height - ReportPageFigure.PAGE_BORDER.top);
            g.setStroke(oldStroke);
        }
    }
}

