/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.commands.SetAbsolutePositionCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.UIUtil;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.swt.events.KeyEvent;

public class JSSGraphicalViewerKeyHandler
extends GraphicalViewerKeyHandler {
    public JSSGraphicalViewerKeyHandler(GraphicalViewer viewer) {
        super(viewer);
    }

    public boolean keyPressed(KeyEvent event) {
        GraphicalViewer viewer;
        if (UIUtil.isArrowKey(event.keyCode) && (viewer = this.getViewer()) instanceof GraphicalViewer) {
            JSSCompoundCommand ccmd = new JSSCompoundCommand(null);
            for (Object selectedEditPart : this.getViewer().getSelectedEditParts()) {
                Object modelObj;
                if (!(selectedEditPart instanceof GraphicalEditPart) || !((modelObj = ((EditPart)selectedEditPart).getModel()) instanceof MGraphicElement)) continue;
                MGraphicElement node = (MGraphicElement)modelObj;
                ccmd.add(this.getNewXYCommand(event.keyCode, node));
            }
            if (!ccmd.isEmpty()) {
                this.getViewer().getEditDomain().getCommandStack().execute((Command)ccmd);
                return true;
            }
        }
        return super.keyPressed(event);
    }

    private Command getNewXYCommand(int arrowKeyCode, MGraphicElement node) {
        int step = 1;
        if (JasperReportsPlugin.isPressed((int)131072)) {
            step = 10;
        }
        Integer x = (Integer)node.getPropertyValue("x");
        Integer y = (Integer)node.getPropertyValue("y");
        Integer width = (Integer)node.getPropertyValue("width");
        Integer height = (Integer)node.getPropertyValue("height");
        switch (arrowKeyCode) {
            case 0x1000001: {
                y = y - step;
                break;
            }
            case 0x1000002: {
                y = y + step;
                break;
            }
            case 0x1000003: {
                x = x - step;
                break;
            }
            case 0x1000004: {
                x = x + step;
                break;
            }
            default: {
                throw new RuntimeException(Messages.JSSGraphicalViewerKeyHandler_ErrorNoArrowKey);
            }
        }
        SetAbsolutePositionCommand cmd = new SetAbsolutePositionCommand();
        cmd.setContext(node, new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue()));
        return cmd;
    }

    protected GraphicalEditPart getFocusEditPart() {
        EditPart part = this.getViewer().getFocusEditPart();
        if (part instanceof GraphicalEditPart) {
            return (GraphicalEditPart)part;
        }
        return null;
    }
}

