/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import java.lang.reflect.Field;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.zoom.AbstractZoomManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.widgets.Display;

public class JSSZoomManager
extends ZoomManager {
    protected Field privateStringField = null;
    protected ZOOM_TYPE zoomType = ZOOM_TYPE.KEEP_CENTER;
    private EditPart parent;

    public JSSZoomManager(ScalableFigure pane, Viewport viewport, EditPart parent, ZOOM_TYPE style) {
        super(pane, viewport);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)((Object)style));
        this.parent = parent;
        this.zoomType = style;
        try {
            try {
                this.privateStringField = ZoomManager.class.getDeclaredField("zoom");
            }
            catch (NoSuchFieldException | SecurityException exception) {
                try {
                    this.privateStringField = AbstractZoomManager.class.getDeclaredField("zoom");
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    JaspersoftStudioPlugin.getInstance().logError("Something went wrong trying to detect the zoom information from the GEF ZoomManager class.", ex);
                }
                if (this.privateStringField != null) {
                    this.privateStringField.setAccessible(true);
                }
            }
        }
        finally {
            if (this.privateStringField != null) {
                this.privateStringField.setAccessible(true);
            }
        }
    }

    public JSSZoomManager(ScalableFigure pane, Viewport viewport) {
        super(pane, viewport);
    }

    protected boolean forceSetZoom(Double zoom) {
        if (this.privateStringField != null) {
            try {
                this.privateStringField.set((Object)this, zoom);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected Point calculateZoomPoint() {
        Point p1 = null;
        switch (this.zoomType) {
            case KEEP_CENTER: {
                p1 = this.getViewport().getClientArea().getCenter();
                break;
            }
            case CENTER_TO_MOUSE: {
                Display display = UIUtils.getDisplay();
                org.eclipse.swt.graphics.Point point = this.parent.getViewer().getControl().toControl(display.getCursorLocation());
                p1 = new Point(point.x, point.y);
                this.getScalableFigure().translateToRelative((Translatable)p1);
            }
        }
        return p1;
    }

    protected void noReflectionPrimSetZoom(double zoom) {
        Point p1 = this.calculateZoomPoint();
        if (p1 != null) {
            Point p2 = p1.getCopy();
            Point p = this.getViewport().getViewLocation();
            double prevZoom = this.getZoom();
            super.primSetZoom(zoom);
            p2.scale(zoom / prevZoom);
            Dimension dif = p2.getDifference(p1);
            p.x += dif.width;
            p.y += dif.height;
            this.forceSetViewLocation(p);
        }
    }

    public void setZoomType(ZOOM_TYPE style) {
        Assert.isNotNull((Object)this.parent, (String)"Invalid ZoomManager instance: the parent part is null");
        Assert.isNotNull((Object)((Object)style));
    }

    public void forceSetViewLocation(Point p) {
        super.setViewLocation(p);
    }

    public void setViewLocation(Point p) {
        if (this.zoomType.equals((Object)ZOOM_TYPE.KEEP_CENTER)) {
            super.setViewLocation(p);
        }
    }

    protected void primSetZoom(double zoom) {
        if (this.zoomType.equals((Object)ZOOM_TYPE.KEEP_CENTER)) {
            super.primSetZoom(zoom);
        } else if (this.privateStringField != null) {
            Point p1 = this.calculateZoomPoint();
            if (p1 != null) {
                Point p2 = p1.getCopy();
                Point p = this.getViewport().getViewLocation();
                double prevZoom = this.getZoom();
                boolean result = this.forceSetZoom(zoom);
                if (!result) {
                    this.noReflectionPrimSetZoom(zoom);
                } else {
                    this.getScalableFigure().setScale(zoom);
                    this.fireZoomChanged();
                    this.getViewport().validate();
                    p2.scale(zoom / prevZoom);
                    Dimension dif = p2.getDifference(p1);
                    p.x += dif.width;
                    p.y += dif.height;
                    this.forceSetViewLocation(p);
                }
            }
        } else {
            this.noReflectionPrimSetZoom(zoom);
        }
    }

    public static enum ZOOM_TYPE {
        KEEP_CENTER,
        CENTER_TO_MOUSE;

    }
}

