/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts;

import com.jaspersoft.studio.editor.gef.parts.ReportPageEditPart;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;

public class SnapToGeometryThreshold
extends SnapToGeometry {
    private static JasperDesign jd = null;
    private static Rectangle clientArea = null;

    public SnapToGeometryThreshold(GraphicalEditPart container) {
        super(container);
        if (container instanceof BandEditPart && clientArea == null) {
            jd = ((BandEditPart)container).getJasperDesign();
            clientArea = ((ReportPageEditPart)container.getParent()).getFigure().getClientArea();
        }
    }

    public void setThreshold(double value) {
        super.setThreshold(value);
    }

    protected void populateRowsAndCols(List parts) {
        if (clientArea != null) {
            this.rows = new SnapToGeometry.Entry[parts.size() * 3 + 6];
            this.cols = new SnapToGeometry.Entry[parts.size() * 3 + 6];
            Point topLeft = new Point(SnapToGeometryThreshold.clientArea.x + jd.getLeftMargin(), SnapToGeometryThreshold.clientArea.y);
            Point topRight = new Point(SnapToGeometryThreshold.clientArea.x + jd.getPageWidth() - jd.getRightMargin(), SnapToGeometryThreshold.clientArea.y);
            Point bottomLeft = new Point(topLeft.x, SnapToGeometryThreshold.clientArea.y + jd.getPageHeight());
            Point bottomRight = new Point(topRight.x, SnapToGeometryThreshold.clientArea.y + jd.getPageHeight());
            int startPost = parts.size() * 3;
            this.cols[startPost] = new ThresholdEntry(-1, topLeft.x);
            this.rows[startPost] = new ThresholdEntry(-1, topLeft.y);
            this.cols[startPost + 1] = new ThresholdEntry(0, topLeft.x + (bottomLeft.x - 1) / 2);
            this.rows[startPost + 1] = new ThresholdEntry(0, topLeft.y + (bottomLeft.y - 1) / 2);
            this.cols[startPost + 2] = new ThresholdEntry(1, bottomLeft.x - 1);
            this.rows[startPost + 2] = new ThresholdEntry(1, bottomLeft.y - 1);
            this.cols[startPost += 3] = new ThresholdEntry(-1, topRight.x);
            this.rows[startPost] = new ThresholdEntry(-1, topRight.y);
            this.cols[startPost + 1] = new ThresholdEntry(0, topRight.x + (bottomRight.x - 1) / 2);
            this.rows[startPost + 1] = new ThresholdEntry(0, topRight.y + (bottomRight.y - 1) / 2);
            this.cols[startPost + 2] = new ThresholdEntry(1, bottomRight.x - 1);
            this.rows[startPost + 2] = new ThresholdEntry(1, bottomRight.y - 1);
        } else {
            this.rows = new SnapToGeometry.Entry[parts.size() * 3];
            this.cols = new SnapToGeometry.Entry[parts.size() * 3];
        }
        int i = 0;
        while (i < parts.size()) {
            GraphicalEditPart child = (GraphicalEditPart)parts.get(i);
            Rectangle bounds = this.getFigureBounds(child);
            this.cols[i * 3] = new ThresholdEntry(-1, bounds.x);
            this.rows[i * 3] = new ThresholdEntry(-1, bounds.y);
            this.cols[i * 3 + 1] = new ThresholdEntry(0, bounds.x + (bounds.width - 1) / 2);
            this.rows[i * 3 + 1] = new ThresholdEntry(0, bounds.y + (bounds.height - 1) / 2);
            this.cols[i * 3 + 2] = new ThresholdEntry(1, bounds.right() - 1);
            this.rows[i * 3 + 2] = new ThresholdEntry(1, bounds.bottom() - 1);
            ++i;
        }
    }

    protected List generateSnapPartsList(List exclusions) {
        ArrayList children = new ArrayList();
        if (exclusions.size() > 0) {
            EditPart selectedItem = (EditPart)exclusions.get(0);
            children.addAll(selectedItem.getParent().getChildren());
            children.removeAll(exclusions);
            ArrayList<GraphicalEditPart> hiddenChildren = new ArrayList<GraphicalEditPart>();
            for (GraphicalEditPart child : children) {
                if (child.getFigure().isVisible()) continue;
                hiddenChildren.add(child);
            }
            children.removeAll(hiddenChildren);
        }
        return children;
    }

    protected static class ThresholdEntry
    extends SnapToGeometry.Entry {
        protected ThresholdEntry(int type, int location) {
            super(type, location);
        }
    }
}

