/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.band;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.parts.band.BandButtonPadLocator;
import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BandButtonPadHandle
extends AbstractHandle {
    private static final int DEFAULT_PAD_WIDTH = 100;
    private static final int DEFAULT_PAD_HEIGHT = 20;
    private static final double MINIMUM_ZOOM_SCALE = 0.75;

    public BandButtonPadHandle(GraphicalEditPart owner) {
        super(owner, (Locator)new BandButtonPadLocator(owner.getFigure()));
        this.createButtons();
    }

    private void createButtons() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 2;
        gridLayout.horizontalSpacing = 10;
        this.setLayoutManager((LayoutManager)gridLayout);
        ImageFigure btn1 = new ImageFigure(JaspersoftStudioPlugin.getInstance().getImage("/icons/resources/eclipse/etool16/delete_edit.gif"));
        btn1.setToolTip((IFigure)new Label("Delete band"));
        btn1.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
                boolean deleteOK = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Delete band", (String)"Are you sure you want to delete the band?");
                if (deleteOK) {
                    GroupRequest request = new GroupRequest((Object)"delete");
                    request.setEditParts((EditPart)BandButtonPadHandle.this.getOwner());
                    Command delcmd = BandButtonPadHandle.this.getOwner().getCommand((Request)request);
                    if (delcmd != null && delcmd.canExecute()) {
                        BandButtonPadHandle.this.getCommandStack().execute(delcmd);
                    }
                }
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        btn1.setCursor(Cursors.HAND);
        this.add((IFigure)btn1);
        GridData imgFigGD = new GridData(128, 4, true, false);
        gridLayout.setConstraint((IFigure)btn1, (Object)imgFigGD);
    }

    private CommandStack getCommandStack() {
        return this.getOwner().getViewer().getEditDomain().getCommandStack();
    }

    protected DragTracker createDragTracker() {
        return null;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isZoomOK() && this.isSingleSelected()) {
            Graphics2D g;
            Rectangle padBounds = this.getBounds().getCopy();
            padBounds.width = 100;
            padBounds.height = 20;
            this.setBounds(padBounds);
            Rectangle r = padBounds.getCopy();
            if (graphics instanceof J2DGraphics) {
                g = ((J2DGraphics)graphics).getGraphics2D();
                g.setColor(new Color(223, 237, 249));
                g.fillArc(r.x + r.width - 22, r.y, 20, 40, 0, 90);
                g.fillArc(r.x + 2, r.y, 20, 40, 90, 90);
                g.fillRect(r.x + 10, r.y, r.width - 20, r.height);
            } else {
                graphics.fillRectangle(r);
            }
            if (graphics instanceof J2DGraphics) {
                g = ((J2DGraphics)graphics).getGraphics2D();
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(new Color(181, 198, 209));
                g.draw(new Arc2D.Double(r.x + r.width - 22, r.y, 20.0, 40.0, 0.0, 90.0, 0));
                g.draw(new Arc2D.Double(r.x + 2, r.y, 20.0, 40.0, 90.0, 90.0, 0));
                g.drawLine(r.x + 11, r.y, r.x + r.width - 11, r.y);
                g.setColor(Color.WHITE);
                g.draw(new Arc2D.Double(r.x + r.width - 23, r.y + 1, 20.0, 40.0, 0.0, 90.0, 0));
                g.draw(new Arc2D.Double(r.x + 3, r.y + 1, 20.0, 40.0, 90.0, 90.0, 0));
                g.drawLine(r.x + 11, r.y + 1, r.x + r.width - 11, r.y + 1);
            } else {
                graphics.drawRectangle(r);
            }
        }
    }

    protected void paintChildren(Graphics graphics) {
        if (this.isZoomOK() && this.isSingleSelected()) {
            super.paintChildren(graphics);
        }
    }

    private boolean isSingleSelected() {
        return this.getOwner().getSelected() == 2 && ((IStructuredSelection)this.getOwner().getViewer().getSelection()).size() == 1;
    }

    private boolean isZoomOK() {
        ZoomManager zoomManager = (ZoomManager)this.getOwner().getViewer().getProperty(ZoomManager.class.toString());
        return zoomManager != null && zoomManager.getZoom() >= 0.75;
    }
}

