/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ColoredRectangle;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.ZoomManager;

public class ColoredLayoutPositionRectangle
extends ColoredRectangle {
    private ANode container;
    private List<Object> nodes;
    private Map<Object, Rectangle> positions = null;
    private List<Object> elements = new ArrayList<Object>();
    private boolean hasPosition = true;
    private static HashMap<Class<?>, JRElement> newElementsCache = new HashMap();
    private int insertPosition;
    private EditPart part;

    public ColoredLayoutPositionRectangle(EditPart part, Color borderColor, float borderWidth, ANode container, List<Object> nodes) {
        this(part, borderColor, borderWidth, container, nodes, -1);
    }

    public ColoredLayoutPositionRectangle(EditPart part, Color borderColor, float borderWidth, ANode container, List<Object> nodes, int insertPosition) {
        super(borderColor, borderWidth);
        this.container = container;
        this.nodes = nodes;
        this.insertPosition = insertPosition;
        this.part = part;
    }

    private JRElement getEmptyElement(MGraphicElement node) {
        JRElement value = newElementsCache.get(node.getClass());
        if (value == null) {
            value = node.createJRElement(this.container.getJasperDesign(), false);
            newElementsCache.put(node.getClass(), value);
        }
        return value;
    }

    private Map<Object, Rectangle> getLayoutPosition() {
        if (!this.hasPosition) {
            return null;
        }
        if (this.positions != null) {
            return this.positions;
        }
        this.elements.clear();
        for (Object node : this.nodes) {
            if (node instanceof MGraphicElement) {
                MGraphicElement pNode = (MGraphicElement)node;
                if (pNode.getValue() != null && pNode.getValue() instanceof JRElement) {
                    this.elements.add(pNode.getValue());
                    continue;
                }
                this.elements.add(this.getEmptyElement(pNode));
                continue;
            }
            if (node instanceof ANode) {
                this.elements.add(((ANode)node).getValue());
                continue;
            }
            this.elements.add(node);
        }
        this.positions = LayoutManager.createLayoutPosition(this.container, this.insertPosition, this.elements);
        if (this.positions == null) {
            this.hasPosition = false;
        }
        return this.positions;
    }

    @Override
    protected void outlineShape(Graphics graphics) {
        Map<Object, Rectangle> positions;
        super.outlineShape(graphics);
        ZoomManager zoomMgr = (ZoomManager)this.part.getViewer().getProperty(ZoomManager.class.toString());
        double zoom = 1.0;
        if (zoomMgr != null) {
            zoom = zoomMgr.getZoom();
        }
        if ((positions = this.getLayoutPosition()) != null) {
            Graphics2D g = ComponentFigure.getG2D(graphics);
            Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
            int offset = 0;
            if (this.container instanceof MBand) {
                JasperDesign jd = this.container.getJasperDesign();
                offset = (int)Math.round((double)jd.getLeftMargin() * zoom);
            }
            for (Rectangle elementPosition : positions.values()) {
                if (elementPosition == null) continue;
                g.setStroke(new BasicStroke(this.borderWidth));
                g.setColor(new Color(159, 159, 159));
                int x1 = (int)Math.round((double)elementPosition.x * zoom) + offset + r.x;
                int y1 = r.y + (int)Math.round((double)elementPosition.y * zoom);
                Rectangle rect = new Rectangle(x1, y1, (int)Math.round((double)elementPosition.width * zoom), (int)Math.round((double)elementPosition.height * zoom));
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

