/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.RedrawingEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ElementFeedbackFigure;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.JSSCompoundResizeTracker;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.SearchParentDragTracker;
import com.jaspersoft.studio.editor.gef.selection.ColoredSquareHandles;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Cursor;

public class ElementResizableEditPolicy
extends RedrawingEditPolicy {
    protected List<?> createSelectionHandles() {
        if (this.getResizeDirections() == 0) {
            return super.createSelectionHandles();
        }
        ArrayList list = new ArrayList();
        this.createMoveHandle(list);
        this.createResizeHandle(list, 1);
        this.createResizeHandle(list, 16);
        this.createResizeHandle(list, 4);
        this.createResizeHandle(list, 8);
        this.createResizeHandle(list, 20);
        this.createResizeHandle(list, 12);
        this.createResizeHandle(list, 9);
        this.createResizeHandle(list, 17);
        return list;
    }

    @Override
    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        String s = "";
        int scaleH = 0;
        int scaleW = 0;
        if (this.getHost() instanceof FigureEditPart && ((FigureEditPart)this.getHost()).getModelNode().getValue() instanceof JRDesignElement) {
            JRDesignElement jrElement = (JRDesignElement)((FigureEditPart)this.getHost()).getModelNode().getValue();
            Rectangle oldBounds = new Rectangle(jrElement.getX(), jrElement.getY(), jrElement.getWidth(), jrElement.getHeight());
            PrecisionRectangle rect2 = new PrecisionRectangle(new Rectangle(request.getMoveDelta().x, request.getMoveDelta().y, request.getSizeDelta().width, request.getSizeDelta().height));
            this.getHostFigure().translateToRelative((Translatable)rect2);
            oldBounds.translate(rect2.x, rect2.y);
            oldBounds.resize(rect2.width, rect2.height);
            s = String.valueOf(s) + oldBounds.x + ", " + oldBounds.y + ", " + oldBounds.width + ", " + oldBounds.height;
            if (oldBounds.width != 0) {
                scaleW = rect.width / oldBounds.width - 1;
            }
            if (oldBounds.height != 0) {
                scaleH = rect.height / oldBounds.height - 1;
            }
        }
        feedback.translateToRelative((Translatable)rect);
        ((ElementFeedbackFigure)feedback).setText(s);
        feedback.setBounds(rect.resize(-scaleW, -scaleH));
        super.showChangeBoundsFeedback(request);
    }

    protected void createMoveHandle(List handles) {
        if (this.isDragAllowed()) {
            ResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), (List)handles, (DragTracker)this.getDragTracker(), (Cursor)Cursors.SIZEALL);
        } else {
            ResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), (List)handles, (DragTracker)this.getSelectTracker(), (Cursor)SharedCursors.ARROW);
        }
    }

    protected void createDragHandle(List handles, int direction) {
        if (this.isDragAllowed()) {
            NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), (List)handles, (int)direction, (DragTracker)this.getDragTracker(), (Cursor)SharedCursors.SIZEALL);
        } else {
            NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), (List)handles, (int)direction, (DragTracker)this.getSelectTracker(), (Cursor)SharedCursors.ARROW);
        }
    }

    protected void createResizeHandle(List handles, int direction) {
        if ((this.getResizeDirections() & direction) == direction) {
            ColoredSquareHandles handle = new ColoredSquareHandles((GraphicalEditPart)this.getHost(), direction);
            handle.setDragTracker((DragTracker)this.getResizeTracker(direction));
            handle.setCursor(Cursors.getDirectionalCursor((int)direction, (boolean)this.getHostFigure().isMirrored()));
            handles.add(handle);
        } else {
            this.createDragHandle(handles, direction);
        }
    }

    protected IFigure createDragSourceFeedbackFigure() {
        ElementFeedbackFigure r = new ElementFeedbackFigure();
        r.setLineStyle(3);
        r.setForegroundColor(ColorConstants.black);
        r.setBounds(this.getInitialFeedbackBounds().resize(-1, -1));
        this.addFeedback((IFigure)r);
        return r;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    protected DragEditPartsTracker getDragTracker() {
        return new SearchParentDragTracker(this.getHost());
    }

    protected SelectEditPartTracker getSelectTracker() {
        return new SelectEditPartTracker(this.getHost());
    }

    protected ResizeTracker getResizeTracker(int direction) {
        return new JSSCompoundResizeTracker((GraphicalEditPart)this.getHost(), direction);
    }

    public List<?> getHandles() {
        return this.handles;
    }
}

