/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class JSSSnapFeedBackPolicy
extends GraphicalEditPolicy {
    IFigure[] guide = new IFigure[6];
    Integer[] location = new Integer[6];

    public void eraseTargetFeedback(Request request) {
        int i = 0;
        while (i < this.guide.length) {
            if (this.guide[i] != null) {
                this.removeFeedback(this.guide[i]);
            }
            this.guide[i] = null;
            this.location[i] = null;
            ++i;
        }
    }

    void highlightGuide(Integer pos, Color color, int offset) {
        if (pos == null) {
            if (this.guide[offset] != null) {
                this.removeFeedback(this.guide[offset]);
                this.guide[offset] = null;
            }
            this.location[offset] = pos;
            return;
        }
        int position = pos;
        PrecisionPoint loc = new PrecisionPoint(position, position);
        IFigure contentPane = ((GraphicalEditPart)this.getHost()).getContentPane();
        contentPane.translateToParent((Translatable)loc);
        contentPane.translateToAbsolute((Translatable)loc);
        if (this.location[offset] == null || !this.location[offset].equals(pos)) {
            this.location[offset] = pos;
            if (this.guide[offset] != null) {
                this.removeFeedback(this.guide[offset]);
                this.guide[offset] = null;
            }
            FadeIn fig = new FadeIn(color);
            this.guide[offset] = fig;
            this.addFeedback((IFigure)fig);
            fig.translateToRelative((Translatable)loc);
            position = offset % 2 == 0 ? (int)Math.round(loc.preciseX()) : (int)Math.round(loc.preciseY());
            Rectangle figBounds = this.getFeedbackLayer().getBounds().getCopy();
            if (offset % 2 == 1) {
                figBounds.height = 1;
                figBounds.y = position;
            } else {
                figBounds.x = position;
                figBounds.width = 1;
            }
            fig.setBounds(figBounds);
        } else {
            IFigure fig = this.guide[offset];
            Rectangle figBounds = fig.getBounds().getCopy();
            Rectangle feedbackBounds = this.getFeedbackLayer().getBounds();
            if (offset % 2 == 1) {
                figBounds.x = feedbackBounds.x;
                figBounds.width = feedbackBounds.width;
            } else {
                figBounds.y = feedbackBounds.y;
                figBounds.height = feedbackBounds.height;
            }
            fig.setBounds(figBounds);
        }
    }

    public void showTargetFeedback(Request req) {
        if (req.getType() == null) {
            return;
        }
        if (req.getType().equals("move") || req.getType().equals("resize") || req.getType().equals("clone") || req.getType().equals("add children") || req.getType().equals("create child")) {
            Integer value = (Integer)req.getExtendedData().get("SnapToGeometry.WestAnchor");
            this.highlightGuide(value, ColorConstants.blue, 0);
            value = (Integer)req.getExtendedData().get("SnapToGeometry.NorthAnchor");
            this.highlightGuide(value, ColorConstants.blue, 1);
            value = (Integer)req.getExtendedData().get("SnapToGeometry.EastAnchor");
            this.highlightGuide(value, ColorConstants.blue, 2);
            value = (Integer)req.getExtendedData().get("SnapToGeometry.SouthAnchor");
            this.highlightGuide(value, ColorConstants.blue, 3);
            value = (Integer)req.getExtendedData().get("SnapToGuides.VerticalGuide");
            this.highlightGuide(value, ColorConstants.blue, 4);
            value = (Integer)req.getExtendedData().get("SnapToGuides.HorizontalGuide");
            this.highlightGuide(value, ColorConstants.blue, 5);
        }
    }

    static class FadeIn
    extends Figure {
        int opacity = 0;
        static final int FRAMES = 6;
        Image image;
        static int count;

        FadeIn(Color bg) {
            this.setForegroundColor(bg);
            super.setOpaque(true);
        }

        private Color createMixedColor() {
            return FigureUtilities.mixColors((Color)this.getLocalBackgroundColor(), (Color)this.getParent().getBackgroundColor(), (double)((double)this.opacity / 6.0));
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.setLineStyle(3);
            graphics.drawRectangle(this.getBounds());
        }

        public void removeNotify() {
            if (this.image != null) {
                this.image.dispose();
                --count;
                this.image = null;
            }
        }
    }
}

