/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.handles;

import com.jaspersoft.studio.JSSCompoundCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.widgets.Display;

public class CellResizeTracker
extends SimpleDragTracker {
    private EditPart editpart;
    private AutoexposeHelper exposeHelper;

    public void deactivate() {
        super.deactivate();
        this.setAutoexposeHelper(null);
    }

    protected void doAutoexpose() {
        if (this.exposeHelper == null) {
            return;
        }
        if (this.exposeHelper.step(this.getLocation())) {
            this.handleAutoexpose();
            Display.getCurrent().asyncExec((Runnable)new QueuedAutoexpose());
        } else {
            this.setAutoexposeHelper(null);
        }
    }

    protected void setAutoexposeHelper(AutoexposeHelper helper) {
        this.exposeHelper = helper;
        if (this.exposeHelper == null) {
            return;
        }
        Display.getCurrent().asyncExec((Runnable)new QueuedAutoexpose());
    }

    protected void updateAutoexposeHelper() {
        if (this.exposeHelper != null) {
            return;
        }
        AutoexposeHelper.Search search = new AutoexposeHelper.Search(this.getLocation());
        this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), (Collection)Collections.EMPTY_LIST, (EditPartViewer.Conditional)search);
        this.setAutoexposeHelper(search.result);
    }

    protected void handleAutoexpose() {
        this.handleMove();
        this.handleDragInProgress();
    }

    public CellResizeTracker(EditPart sourceEditPart) {
        this.setSourceEditPart(sourceEditPart);
        this.setAutoexposeHelper((AutoexposeHelper)new ViewportAutoexposeHelper((GraphicalEditPart)sourceEditPart.getViewer().getRootEditPart()));
        this.updateAutoexposeHelper();
    }

    protected String getCommandName() {
        return "move";
    }

    protected String getDebugName() {
        return "Cell Resize Handle Tracker";
    }

    protected EditPart getSourceEditPart() {
        return this.editpart;
    }

    protected void setSourceEditPart(EditPart part) {
        this.editpart = part;
    }

    protected List<EditPart> createOperationSet() {
        List<EditPart> editparts = null;
        if (this.editpart == null) {
            editparts = Collections.emptyList();
        } else {
            editparts = new ArrayList();
            editparts.add(this.editpart);
            ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)this.getSourceRequest());
        }
        return editparts;
    }

    protected Request createSourceRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
        return request;
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        request.setSizeDelta(new Dimension(d.width, d.height));
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.setResizeDirection(d.height != 0 ? 4 : 16);
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        EditPart part = null;
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        command.setDebugLabel("Move Section Handle Tracker");
        int i = 0;
        while (i < editparts.size()) {
            part = (EditPart)editparts.get(i);
            command.setReferenceNodeIfNull(part.getModel());
            command.add(part.getCommand(this.getSourceRequest()));
            ++i;
        }
        return command.unwrap();
    }

    public boolean handleDragInProgress() {
        boolean b = super.handleDragInProgress();
        this.updateAutoexposeHelper();
        return b;
    }

    class QueuedAutoexpose
    implements Runnable {
        QueuedAutoexpose() {
        }

        @Override
        public void run() {
            CellResizeTracker.this.doAutoexpose();
        }
    }
}

