/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers;

import com.jaspersoft.studio.editor.gef.rulers.ReportRulerGuide;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportRuler
implements Serializable {
    public static final String PROPERTY_CHILDREN = "children changed";
    public static final String PROPERTY_UNIT = "units changed";
    public static final String PROPERTY_HOFFSET = "HOFFSET";
    public static final String PROPERTY_VOFFSET = "VOFFSET";
    public static final String PROPERTY_HEND = "HEND";
    public static final String PROPERTY_VEND = "VEND";
    static final long serialVersionUID = 1L;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private int unit;
    private int hoffset;
    private int voffset;
    private int hend;
    private int vend;
    private boolean horizontal;
    private List<ReportRulerGuide> guides = new ArrayList<ReportRulerGuide>();

    public ReportRuler(boolean isHorizontal) {
        this(isHorizontal, 2);
    }

    public ReportRuler(boolean isHorizontal, int unit) {
        this.horizontal = isHorizontal;
        this.setUnit(unit);
    }

    public void addGuide(ReportRulerGuide guide) {
        if (!this.guides.contains(guide)) {
            guide.setHorizontal(!this.isHorizontal());
            this.guides.add(guide);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public List<ReportRulerGuide> getGuides() {
        return this.guides;
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removeGuide(ReportRulerGuide guide) {
        if (this.guides.remove(guide)) {
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setHidden(boolean isHidden) {
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            int oldUnit = this.unit;
            this.unit = newUnit;
            this.listeners.firePropertyChange(PROPERTY_UNIT, oldUnit, newUnit);
        }
    }

    public int getHoffset() {
        return this.hoffset;
    }

    public void setHoffset(int hoffset) {
        if (this.hoffset != hoffset) {
            int old = this.hoffset;
            this.hoffset = hoffset;
            this.listeners.firePropertyChange(PROPERTY_HOFFSET, old, hoffset);
        }
    }

    public int getVoffset() {
        return this.voffset;
    }

    public void setVoffset(int voffset) {
        if (this.voffset != voffset) {
            int old = this.voffset;
            this.voffset = voffset;
            this.listeners.firePropertyChange(PROPERTY_VOFFSET, old, voffset);
        }
    }

    public int getHend() {
        return this.hend;
    }

    public void setHend(int hend) {
        if (this.hend != hend) {
            int old = this.hend;
            this.hend = hend;
            this.listeners.firePropertyChange(PROPERTY_HEND, old, hend);
        }
    }

    public int getVend() {
        return this.vend;
    }

    public void setVend(int vend) {
        if (this.vend != vend) {
            int old = this.vend;
            this.vend = vend;
            this.listeners.firePropertyChange(PROPERTY_VEND, old, vend);
        }
    }
}

