/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerGuide;
import com.jaspersoft.studio.editor.gef.rulers.command.CreateGuideCommand;
import com.jaspersoft.studio.editor.gef.rulers.command.DeleteGuideCommand;
import com.jaspersoft.studio.editor.gef.rulers.command.MoveGuideCommand;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ReportRulerProvider
extends RulerProvider {
    private ReportRuler ruler;
    private PropertyChangeListener rulerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children changed")) {
                ReportRulerGuide guide = (ReportRulerGuide)evt.getNewValue();
                if (ReportRulerProvider.this.getGuides().contains(guide)) {
                    guide.addPropertyChangeListener(ReportRulerProvider.this.guideListener);
                } else {
                    guide.removePropertyChangeListener(ReportRulerProvider.this.guideListener);
                }
                int i = 0;
                while (i < ReportRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)ReportRulerProvider.this.listeners.get(i)).notifyGuideReparented((Object)guide);
                    ++i;
                }
            } else {
                int newUnit = ReportRulerProvider.this.getUnit();
                int i = 0;
                while (i < ReportRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)ReportRulerProvider.this.listeners.get(i)).notifyUnitsChanged(newUnit);
                    ++i;
                }
            }
        }
    };
    private PropertyChangeListener guideListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("subparts changed")) {
                int i = 0;
                while (i < ReportRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)ReportRulerProvider.this.listeners.get(i)).notifyPartAttachmentChanged(evt.getNewValue(), evt.getSource());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < ReportRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)ReportRulerProvider.this.listeners.get(i)).notifyGuideMoved(evt.getSource());
                    ++i;
                }
            }
        }
    };
    private IPropertyChangeListener preferencesListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("rulerMeasure")) {
                int newUnit = ReportRulerProvider.this.getUnit();
                int i = 0;
                while (i < ReportRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)ReportRulerProvider.this.listeners.get(i)).notifyUnitsChanged(newUnit);
                    ++i;
                }
            }
        }
    };

    public ReportRulerProvider(ReportRuler ruler) {
        this.ruler = ruler;
        this.ruler.addPropertyChangeListener(this.rulerListener);
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        List<ReportRulerGuide> guides = this.getGuides();
        int i = 0;
        while (i < guides.size()) {
            guides.get(i).addPropertyChangeListener(this.guideListener);
            ++i;
        }
    }

    public List<Object> getAttachedModelObjects(Object guide) {
        return new ArrayList<Object>(((ReportRulerGuide)guide).getParts());
    }

    public Command getCreateGuideCommand(int position) {
        return new CreateGuideCommand(this.ruler, position);
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new DeleteGuideCommand((ReportRulerGuide)guide, this.ruler);
    }

    public Command getMoveGuideCommand(Object guide, int pDelta) {
        return new MoveGuideCommand((ReportRulerGuide)guide, pDelta);
    }

    public int[] getGuidePositions() {
        List<ReportRulerGuide> guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = guides.get(i).getPosition();
            ++i;
        }
        return result;
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int getUnit() {
        String measure = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("rulerMeasure");
        int value = 0;
        try {
            if (measure != null && !measure.trim().isEmpty()) {
                value = Integer.parseInt(measure);
            }
        }
        catch (Exception ex) {
            JaspersoftStudioPlugin.getInstance().logError("Invalid Ruler Measure Unit in Preferences", ex);
        }
        return value;
    }

    public void setUnit(int newUnit) {
        if (this.getUnit() != newUnit) {
            JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("rulerMeasure", newUnit);
        }
    }

    public int getGuidePosition(Object guide) {
        return ((ReportRulerGuide)guide).getPosition();
    }

    public List<ReportRulerGuide> getGuides() {
        return this.ruler.getGuides();
    }
}

