/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.actions;

import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.actions.PositionDialog;
import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerEditPart;
import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerFigure;
import com.jaspersoft.studio.messages.Messages;
import java.util.Arrays;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.jface.action.Action;

public class CreateGuideAction
extends Action {
    public static final String ID = "com.jaspersoft.studio.rulers.CreateGuideAction";
    public static final int MIN_DISTANCE_BW_GUIDES = 5;
    private EditPartViewer viewer;

    public CreateGuideAction(EditPartViewer ruler) {
        super(Messages.CreateGuideAction_Label);
        this.viewer = ruler;
        this.setToolTipText(Messages.CreateGuideAction_Tooltip);
        this.setId(ID);
    }

    public void run() {
        JDRulerEditPart rulerEditPart = (JDRulerEditPart)((Object)this.viewer.getRootEditPart().getChildren().get(0));
        RulerProvider provider = rulerEditPart.getRulerProvider();
        ReportRuler ruler = (ReportRuler)provider.getRuler();
        int[] positions = provider.getGuidePositions();
        Arrays.sort(positions);
        int index = 0;
        int newPosition = 6;
        if (rulerEditPart.getMousePosition() != -1) {
            newPosition = rulerEditPart.getMousePosition();
        } else {
            int desiredDifference = 11;
            boolean found = positions.length > 0 && positions[0] > desiredDifference;
            while (index < positions.length - 1 && !found) {
                if (positions[index + 1] - positions[index] > desiredDifference) {
                    newPosition += positions[index];
                    found = true;
                }
                ++index;
            }
            if (!found && positions.length > 0) {
                newPosition += positions[positions.length - 1];
            }
        }
        PositionDialog dlg = new PositionDialog(UIUtils.getShell(), newPosition, provider.getUnit(), ruler.isHorizontal());
        if (dlg.open() == 0) {
            JDRulerFigure rf;
            newPosition = dlg.getPixelPosition();
            this.viewer.getEditDomain().getCommandStack().execute(provider.getCreateGuideCommand(newPosition += (rf = rulerEditPart.getRulerFigure()).isHorizontal() ? rf.getHoffset() : rf.getVoffset()));
            this.viewer.reveal((EditPart)this.viewer.getEditPartRegistry().get(provider.getGuideAt(newPosition)));
        }
    }
}

