/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.actions;

import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerFigure;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;

public final class PositionDialog
extends PersistentLocationDialog {
    private int suggestedPixels;
    private int measureUnit;
    private Combo measureCombo;
    private Text valueText;
    private String lastValidValue;
    private int maximumPixels;
    private static final int[] RULER_MEASURES;
    private static final String[] RULER_NAMES;

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 1;
        RULER_MEASURES = nArray;
        RULER_NAMES = new String[]{Messages.DesignerPreferencePage_pixelMeasure, Messages.DesignerPreferencePage_centimeterMeasure, Messages.DesignerPreferencePage_inchMeasure};
    }

    public PositionDialog(Shell shell, int suggestedPixels, int measureUnit, boolean isHorizontal) {
        super(shell);
        this.measureUnit = measureUnit;
        this.suggestedPixels = suggestedPixels;
        this.maximumPixels = this.calculateMaximum(isHorizontal);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CreateGuideAction_GuidePositionTxt);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        new Label(container, 0).setText(Messages.CreateGuideAction_GuidePositionTxt);
        this.valueText = new Text(container, 133120);
        GridData textData = new GridData(768);
        textData.widthHint = 100;
        this.valueText.setLayoutData((Object)textData);
        this.valueText.setText(this.convertPixelIntoValue(this.suggestedPixels));
        this.lastValidValue = this.valueText.getText();
        this.valueText.setToolTipText(Messages.CreateGuideAction_GuidePositionTooltip);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    float value = Float.parseFloat(PositionDialog.this.valueText.getText().replace(",", "."));
                    PositionDialog.this.suggestedPixels = PositionDialog.this.convertValueIntoPixels(value);
                    if (Math.abs(PositionDialog.this.suggestedPixels) > PositionDialog.this.maximumPixels && PositionDialog.this.maximumPixels != -1) {
                        PositionDialog.this.suggestedPixels = PositionDialog.this.maximumPixels;
                        PositionDialog.this.valueText.removeModifyListener((ModifyListener)this);
                        Point selection = PositionDialog.this.valueText.getSelection();
                        PositionDialog.this.valueText.setText(PositionDialog.this.convertPixelIntoValue(PositionDialog.this.suggestedPixels));
                        PositionDialog.this.valueText.setSelection(selection);
                        PositionDialog.this.valueText.addModifyListener((ModifyListener)this);
                    }
                    PositionDialog.this.lastValidValue = PositionDialog.this.valueText.getText();
                }
                catch (Exception exception) {
                    PositionDialog.this.valueText.setText(PositionDialog.this.lastValidValue);
                }
            }
        });
        this.measureCombo = new Combo(container, 8);
        this.measureCombo.setItems(RULER_NAMES);
        this.measureCombo.select(0);
        int i = 0;
        while (i < RULER_MEASURES.length) {
            if (this.measureUnit == RULER_MEASURES[i]) {
                this.measureCombo.select(i);
                break;
            }
            ++i;
        }
        this.measureCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PositionDialog.this.measureUnit = RULER_MEASURES[PositionDialog.this.measureCombo.getSelectionIndex()];
                PositionDialog.this.lastValidValue = PositionDialog.this.convertPixelIntoValue(PositionDialog.this.suggestedPixels);
                PositionDialog.this.valueText.setText(PositionDialog.this.lastValidValue);
            }
        });
        return container;
    }

    public int getPixelPosition() {
        return this.suggestedPixels;
    }

    protected int convertValueIntoPixels(float value) {
        if (this.measureUnit == 1) {
            return Math.round(value * (float)JDRulerFigure.getDpi().x / 2.54f);
        }
        if (this.measureUnit == 0) {
            return Math.round(value * (float)JDRulerFigure.getDpi().x);
        }
        return Math.round(value);
    }

    protected String convertPixelIntoValue(int pixels) {
        double value = this.measureUnit == 1 ? (double)pixels * 2.54 / (double)JDRulerFigure.getDpi().x : (this.measureUnit == 0 ? (double)pixels / (double)JDRulerFigure.getDpi().x : new Double(pixels));
        DecimalFormat df = new DecimalFormat("##.####");
        df.setRoundingMode(RoundingMode.DOWN);
        return df.format(value);
    }

    protected int calculateMaximum(boolean isHorizontal) {
        AbstractJRXMLEditor jrxmlEditor;
        INode model;
        IEditorPart editor = SelectionHelper.getActiveJRXMLEditor();
        int maximum = -1;
        if (editor != null && (model = (jrxmlEditor = (AbstractJRXMLEditor)editor).getModel()) != null && model instanceof ANode) {
            Point canvasSize = ((ANode)model).getAvailableSize();
            maximum = isHorizontal ? canvasSize.x : canvasSize.y;
        }
        return maximum;
    }
}

