/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.command;

import com.jaspersoft.studio.editor.gef.rulers.ReportRulerGuide;
import com.jaspersoft.studio.model.IGuidebleElement;
import org.eclipse.gef.commands.Command;

public class ChangeGuideCommand
extends Command {
    private IGuidebleElement part;
    private ReportRulerGuide oldGuide;
    private ReportRulerGuide newGuide;
    private int oldAlign;
    private int newAlign;
    private boolean horizontal;

    public ChangeGuideCommand(IGuidebleElement part, boolean horizontalGuide) {
        this.part = part;
        this.horizontal = horizontalGuide;
    }

    protected void changeGuide(ReportRulerGuide oldGuide, ReportRulerGuide newGuide, int newAlignment) {
        if (oldGuide != null && oldGuide != newGuide) {
            oldGuide.detachPart(this.part);
        }
        if (newGuide != null) {
            newGuide.attachPart(this.part, newAlignment);
        }
    }

    public void execute() {
        ReportRulerGuide reportRulerGuide = this.oldGuide = this.horizontal ? this.part.getHorizontalGuide() : this.part.getVerticalGuide();
        if (this.oldGuide != null) {
            this.oldAlign = this.oldGuide.getAlignment(this.part);
        }
        this.redo();
    }

    public void redo() {
        this.changeGuide(this.oldGuide, this.newGuide, this.newAlign);
    }

    public void setNewGuide(ReportRulerGuide guide, int alignment) {
        this.newGuide = guide;
        this.newAlign = alignment;
    }

    public void undo() {
        this.changeGuide(this.newGuide, this.oldGuide, this.oldAlign);
    }
}

