/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.selection;

import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;

public class SelectPartsCommand
extends Command {
    private List<EditPart> elementsToSelect;
    private Pair<ISelection, EditPartViewer> oldSelection = null;

    public SelectPartsCommand(List<EditPart> elementsToSelect) {
        this.elementsToSelect = elementsToSelect;
    }

    public SelectPartsCommand(EditPart elementToSelect) {
        this.elementsToSelect = new ArrayList<EditPart>();
        this.elementsToSelect.add(elementToSelect);
    }

    public void execute() {
        if (!this.elementsToSelect.isEmpty()) {
            this.oldSelection = SelectionHelper.setEditPartsSelection(this.elementsToSelect, false);
        }
    }

    public boolean canExecute() {
        return this.elementsToSelect != null;
    }

    public void undo() {
        if (this.oldSelection != null) {
            ((EditPartViewer)this.oldSelection.getValue()).setSelection((ISelection)this.oldSelection.getKey());
        }
    }
}

