/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.swt.ColorManager;

public class J2DGraphics
extends Graphics {
    private static final Map<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
    public static final J2DKey KEY_USE_JAVA2D;
    public static final J2DKey KEY_FIXED_LINEWIDTH;
    private static final Map<Image, BufferedImage> IMAGE_CACHE;
    private static final float[] DOT_ARRAY;
    private static final float[] DASH_ARRAY;
    private static final float[] DASHDOT_ARRAY;
    private static final float[] DASHDOTDOT_ARRAY;
    private static final java.awt.Color TRANSPARENT;
    private double _dpi = 0.0;
    private Map<org.eclipse.swt.graphics.Font, Font> fontsCache = new HashMap<org.eclipse.swt.graphics.Font, Font>();
    private boolean _xor = false;
    private int _lineStyle = 1;
    private int _lineWidth = 1;
    private Color _bg;
    private Color _fg;
    private java.awt.Color _awtBg;
    private java.awt.Color _awtFg;
    private org.eclipse.swt.graphics.Font _font;
    private Graphics2D _g2d;
    private GC gc;
    private Stack<State> _stack = new Stack();
    private ColorManager colorManager = new ColorManager();

    static {
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        KEY_USE_JAVA2D = new J2DKey(1);
        KEY_FIXED_LINEWIDTH = new J2DKey(2);
        IMAGE_CACHE = new HashMap<Image, BufferedImage>(10);
        DOT_ARRAY = new float[]{2.0f, 2.0f};
        DASH_ARRAY = new float[]{3.0f, 3.0f};
        DASHDOT_ARRAY = new float[]{4.0f, 2.0f, 1.0f, 2.0f};
        DASHDOTDOT_ARRAY = new float[]{4.0f, 2.0f, 1.0f, 2.0f, 1.0f, 2.0f};
        TRANSPARENT = new java.awt.Color(0.3f, 0.3f, 0.3f, 0.5f);
    }

    public void setAlpha(int alpha) {
        this.getGraphics2D().setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
    }

    public int getAlpha() {
        Composite comp = this.getGraphics2D().getComposite();
        if (comp instanceof AlphaComposite) {
            AlphaComposite alphaComp = (AlphaComposite)comp;
            return Math.round(alphaComp.getAlpha() * 255.0f);
        }
        return 255;
    }

    public J2DGraphics(GC gc, Graphics2D g2d) {
        if (gc != null) {
            this._dpi = (double)gc.getDevice().getDPI().x / 72.0;
            this.gc = gc;
            this._fg = gc.getForeground();
            this._bg = gc.getBackground();
            this._font = gc.getFont();
        } else {
            this._fg = this.toSWTColor(g2d.getColor());
            this._bg = this.toSWTColor(g2d.getBackground());
        }
        this._g2d = g2d;
        g2d.setRenderingHints(hints);
        this.updateStroke();
        this.updateColors();
        this.updateFont();
    }

    public Graphics2D createGraphics2D() {
        return (Graphics2D)this._g2d.create();
    }

    public Graphics2D getGraphics2D() {
        return this._g2d;
    }

    protected void updateFont() {
        if (this._font == null) {
            return;
        }
        Font cachedAWTFont = this.fontsCache.get(this._font);
        if (cachedAWTFont == null) {
            FontData fd = this._font.getFontData()[0];
            int style = fd.getStyle();
            int awtStyle = 0;
            if ((style & 1) == 1) {
                awtStyle = 1;
            }
            if ((style & 2) == 2) {
                awtStyle |= 2;
            }
            cachedAWTFont = new Font(fd.getName(), awtStyle, (int)Math.round((double)fd.getHeight() * this._dpi));
            this.fontsCache.put(this._font, cachedAWTFont);
        }
        this._g2d.setFont(cachedAWTFont);
    }

    protected void updateColors() {
        if (this._awtBg == null) {
            this._awtBg = J2DGraphics.toAWTColor(this._bg);
        }
        this._g2d.setBackground(this._awtBg);
        if (this._awtFg == null) {
            this._awtFg = J2DGraphics.toAWTColor(this._fg);
        }
        this._g2d.setColor(this._awtFg);
        if (this._xor) {
            this._g2d.setXORMode(TRANSPARENT);
        } else {
            this._g2d.setPaintMode();
        }
    }

    protected void updateStroke() {
        BasicStroke stroke = null;
        float lw = this._lineWidth;
        if (this._g2d.getRenderingHint(KEY_FIXED_LINEWIDTH) == Boolean.TRUE) {
            lw = (float)((double)lw / this._g2d.getTransform().getScaleX());
        }
        switch (this._lineStyle) {
            case 3: {
                stroke = new BasicStroke(lw, 2, 0, 10.0f, DOT_ARRAY, 1.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(lw, 2, 0, 10.0f, DASH_ARRAY, 0.0f);
                break;
            }
            case 4: {
                stroke = new BasicStroke(lw, 2, 0, 10.0f, DASHDOT_ARRAY, 2.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(lw, 2, 0, 10.0f, DASHDOTDOT_ARRAY, 2.0f);
                break;
            }
            default: {
                stroke = new BasicStroke(lw, 2, 0, 10.0f, null, 0.0f);
            }
        }
        this._g2d.setStroke(stroke);
    }

    public void clipRect(Rectangle r) {
        if (r == null) {
            this._g2d.setClip(null);
        } else {
            this._g2d.setClip(r.x, r.y, r.width, r.height);
        }
    }

    public void dispose() {
        this.colorManager.dispose();
        this.fontsCache.clear();
        this._g2d.dispose();
        this._g2d = null;
        this._stack.removeAllElements();
        this._stack = null;
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        this._g2d.drawArc(x, y, w, h, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        int ls = this._lineStyle;
        this.setLineStyle(3);
        this._g2d.drawRect(x, y, w, h);
        this.setLineStyle(ls);
    }

    protected BufferedImage convertSWTImage(Image src) {
        BufferedImage dst = IMAGE_CACHE.get(src);
        if (dst != null) {
            return dst;
        }
        ImageData data = src.getImageData();
        dst = new BufferedImage(data.width, data.height, 2);
        ImageData mask = data.getTransparencyMask();
        RGB[] rgbs = data.getRGBs();
        int yy = 0;
        while (yy < data.height) {
            int xx = 0;
            while (xx < data.width) {
                int a = mask.getPixel(xx, yy);
                int rgb = data.getPixel(xx, yy);
                if (a == 1) {
                    a = 255;
                }
                if (rgbs != null) {
                    RGB p = rgbs[rgb];
                    dst.setRGB(xx, yy, a << 24 | p.red << 16 | p.green << 8 | p.blue);
                } else {
                    dst.setRGB(xx, yy, a << 24 | rgb);
                }
                ++xx;
            }
            ++yy;
        }
        IMAGE_CACHE.put(src, dst);
        return dst;
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        BufferedImage dst = this.convertSWTImage(srcImage);
        this._g2d.drawImage(dst, x1, y1, x1 + w1, y1 + h1, x2, y2, x2 + w2, y2 + h2, null);
    }

    public void drawImage(Image srcImage, int x, int y) {
        BufferedImage dst = this.convertSWTImage(srcImage);
        this._g2d.drawImage(dst, null, x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this._g2d.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int w, int h) {
        this._g2d.drawOval(x, y, w, h);
    }

    public void drawPolygon(PointList points) {
        Point p = new Point();
        int n = points.size();
        int[] xc = new int[n];
        int[] yc = new int[n];
        int i = 0;
        while (i < n) {
            points.getPoint(p, i);
            xc[i] = p.x;
            yc[i] = p.y;
            ++i;
        }
        this._g2d.drawPolygon(xc, yc, n);
    }

    public void drawPolyline(PointList points) {
        Point p = new Point();
        int n = points.size();
        int[] xc = new int[n];
        int[] yc = new int[n];
        int i = 0;
        while (i < n) {
            points.getPoint(p, i);
            xc[i] = p.x;
            yc[i] = p.y;
            ++i;
        }
        this._g2d.drawPolyline(xc, yc, n);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this._g2d.drawRect(x, y, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this._g2d.drawRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        java.awt.FontMetrics fm = this._g2d.getFontMetrics();
        int dy = fm.getAscent();
        this._g2d.drawString(s, x, y + dy);
    }

    public void drawText(String s, int x, int y) {
        this.drawString(s, x, y);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        this._g2d.setColor(this._awtBg);
        this._g2d.fillArc(x, y, w, h, offset, length);
        this._g2d.setColor(this._awtFg);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        GradientPaint p = null;
        p = vertical ? new GradientPaint(x, y, this._awtFg, x, y + h, this._awtBg) : new GradientPaint(x, y, this._awtFg, x + w, y, this._awtBg);
        this._g2d.setPaint(p);
        this._g2d.fillRect(x, y, w, h);
        this._g2d.setPaint(this._awtFg);
    }

    public void fillOval(int x, int y, int w, int h) {
        this._g2d.setColor(this._awtBg);
        this._g2d.fillOval(x, y, w, h);
        this._g2d.setColor(this._awtFg);
    }

    public void fillPolygon(PointList points) {
        Point p = new Point();
        int n = points.size();
        int[] xc = new int[n];
        int[] yc = new int[n];
        int i = 0;
        while (i < n) {
            points.getPoint(p, i);
            xc[i] = p.x;
            yc[i] = p.y;
            ++i;
        }
        this._g2d.setColor(this._awtBg);
        this._g2d.fillPolygon(xc, yc, n);
        this._g2d.setColor(this._awtFg);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this._g2d.setColor(this._awtBg);
        this._g2d.fillRect(x, y, width, height);
        this._g2d.setColor(this._awtFg);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this._g2d.setColor(this._awtBg);
        this._g2d.fillRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
        this._g2d.setColor(this._awtFg);
    }

    public void fillString(String s, int x, int y) {
        this._g2d.drawString(s, x, y);
    }

    public void fillText(String s, int x, int y) {
        this._g2d.drawString(s, x, y);
    }

    public double getAbsoluteScale() {
        return this._g2d.getTransform().getScaleX();
    }

    public Color getBackgroundColor() {
        return this._bg;
    }

    public Rectangle getClip(Rectangle rect) {
        return J2DGraphics.toDraw2D(this._g2d.getClipBounds(J2DGraphics.toJava2D(rect)));
    }

    public org.eclipse.swt.graphics.Font getFont() {
        return this._font;
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm = this.gc.getFontMetrics();
        return fm;
    }

    public Color getForegroundColor() {
        return this._fg;
    }

    public int getLineStyle() {
        return this._lineStyle;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public boolean getXORMode() {
        return this._xor;
    }

    public void popState() {
        this._stack.pop().restore().dispose();
    }

    public void pushState() {
        this._stack.push(new State());
    }

    public void restoreState() {
        this._stack.peek().restore();
    }

    public void scale(double amount) {
        this._g2d.scale(amount, amount);
        this.updateStroke();
    }

    public void setBackgroundColor(Color rgb) {
        this._bg = rgb;
        this._awtBg = null;
        this.updateColors();
    }

    public void setClip(Rectangle r) {
        this._g2d.setClip(r.x, r.y, r.width, r.height);
    }

    public void setFont(org.eclipse.swt.graphics.Font f) {
        this._font = f;
        this.updateFont();
    }

    public void setForegroundColor(Color rgb) {
        this._fg = rgb;
        this._awtFg = null;
        this.updateColors();
    }

    public void setLineStyle(int style) {
        this._lineStyle = style;
        this.updateStroke();
    }

    public void setLineWidth(int width) {
        this._lineWidth = width;
        this.updateStroke();
    }

    public void setXORMode(boolean b) {
        this._xor = b;
        this.updateColors();
    }

    public void translate(int dx, int dy) {
        this._g2d.translate(dx, dy);
    }

    public static synchronized void flushImageCache() {
        Iterator<Image> keys = IMAGE_CACHE.keySet().iterator();
        while (keys.hasNext()) {
            Image img = keys.next();
            if (!img.isDisposed()) continue;
            keys.remove();
        }
    }

    public static Rectangle toDraw2D(java.awt.Rectangle r) {
        return new Rectangle(r.x, r.y, r.width, r.height);
    }

    public static java.awt.Rectangle toJava2D(Rectangle r) {
        return new java.awt.Rectangle(r.x, r.y, r.width, r.height);
    }

    public static java.awt.Color toAWTColor(Color c) {
        if (c.isDisposed()) {
            return new java.awt.Color(0, 0, 0);
        }
        return new java.awt.Color(c.getRed(), c.getGreen(), c.getBlue());
    }

    public Color toSWTColor(java.awt.Color c) {
        return this.colorManager.getColor(new RGB(c.getRed(), c.getGreen(), c.getBlue()));
    }

    public void setLineAttributes(LineAttributes paramLineAttributes) {
        this.setLineWidthFloat(paramLineAttributes.width);
        this.setLineStyle(paramLineAttributes.style);
    }

    public LineAttributes getLineAttributes() {
        LineAttributes localLineAttributes = new LineAttributes(this.getLineWidthFloat());
        new LineAttributes(this.getLineWidthFloat()).style = this.getLineStyle();
        return localLineAttributes;
    }

    public float getLineWidthFloat() {
        return this.getLineWidth();
    }

    public void setLineMiterLimit(float paramFloat) {
    }

    public void setLineWidthFloat(float paramFloat) {
        this.setLineWidth((int)paramFloat);
    }

    public void setAdvanced(boolean paramBoolean) {
    }

    public boolean getAdvanced() {
        return false;
    }

    private static class J2DKey
    extends RenderingHints.Key {
        public J2DKey(int privatekey) {
            super(privatekey);
        }

        @Override
        public boolean isCompatibleValue(Object val) {
            return val == Boolean.TRUE || val == Boolean.FALSE;
        }
    }

    private class State {
        boolean xor;
        int lineStyle;
        int lineWidth;
        Color bg;
        Color fg;
        org.eclipse.swt.graphics.Font f;
        Shape clip;
        AffineTransform t;

        public State() {
            this.xor = J2DGraphics.this._xor;
            this.lineStyle = J2DGraphics.this._lineStyle;
            this.lineWidth = J2DGraphics.this._lineWidth;
            this.bg = J2DGraphics.this._bg;
            this.fg = J2DGraphics.this._fg;
            this.f = J2DGraphics.this._font;
            this.clip = J2DGraphics.this._g2d.getClip();
            this.t = J2DGraphics.this._g2d.getTransform();
        }

        public State restore() {
            J2DGraphics.this._xor = this.xor;
            J2DGraphics.this._lineStyle = this.lineStyle;
            J2DGraphics.this._lineWidth = this.lineWidth;
            J2DGraphics.this._bg = this.bg;
            J2DGraphics.this._fg = this.fg;
            J2DGraphics.this.updateStroke();
            J2DGraphics.this._awtFg = null;
            J2DGraphics.this._awtBg = null;
            J2DGraphics.this.updateColors();
            J2DGraphics.this._font = this.f;
            J2DGraphics.this.updateFont();
            J2DGraphics.this._g2d.setTransform(this.t);
            J2DGraphics.this._g2d.setClip(this.clip);
            return this;
        }

        public void dispose() {
        }
    }
}

