/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d;

import com.jaspersoft.studio.editor.java2d.ImageRenderer;
import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import com.jaspersoft.studio.editor.java2d.RendererFactory;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class J2DGraphicsSource
implements GraphicsSource {
    private BufferedImage offsceeenBufferedImage;
    private Graphics2D graphics2d;
    private Control c;
    private GC graphicsContext;
    private Rectangle e;
    private ImageRenderer renderer = RendererFactory.a();

    public Graphics2D getGraphics2d() {
        return this.graphics2d;
    }

    public J2DGraphicsSource(Control paramControl) {
        this.c = paramControl;
    }

    public J2DGraphicsSource(GC gc) {
        this.graphicsContext = gc;
    }

    public final Graphics getGraphics(Rectangle paramRectangle) {
        Object localObject;
        if ((this.c == null || this.c.isDisposed()) && this.graphicsContext == null) {
            return null;
        }
        if (this.c != null) {
            localObject = this.c.getSize();
            this.e = new Rectangle(0, 0, localObject.x, localObject.y);
        } else {
            localObject = this.graphicsContext.getClipping();
            this.e = new Rectangle(localObject.x, localObject.y, localObject.width, localObject.height);
        }
        this.e.intersect(paramRectangle);
        if (this.e.isEmpty()) {
            return null;
        }
        this.offsceeenBufferedImage = new BufferedImage(this.e.width, this.e.height, 2);
        this.graphics2d = this.offsceeenBufferedImage.createGraphics();
        if (this.c != null) {
            this.graphicsContext = new GC((Drawable)this.c);
        }
        localObject = new J2DGraphics(this.graphicsContext, this.graphics2d);
        localObject.translate(this.e.getLocation().negate());
        localObject.setClip(paramRectangle);
        localObject.clipRect(this.e.getCopy());
        return localObject;
    }

    public final void flushGraphics(Rectangle paramRectangle) {
        if (this.e.isEmpty()) {
            return;
        }
        int[] imagePixels = ((DataBufferInt)this.offsceeenBufferedImage.getData().getDataBuffer()).getData();
        this.renderer.render(this.getDisplay(), this.graphicsContext, imagePixels, 0, 0, this.e.width, this.e.height, this.e.x, this.e.y, this.e.width, this.e.height);
        J2DGraphics.flushImageCache();
        if (this.c != null) {
            this.graphicsContext.dispose();
            if (Util.isMac()) {
                this.c.redraw();
            }
        }
        this.graphics2d.dispose();
    }

    private Display getDisplay() {
        if (this.c != null) {
            return this.c.getDisplay();
        }
        return UIUtils.getDisplay();
    }
}

