/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d;

import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import com.jaspersoft.studio.editor.java2d.J2DGraphicsSource;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public final class J2DUpdateManager
extends DeferredUpdateManager {
    private IFigure rootFigure;
    private List<IFigure> invalidFigures = new ArrayList<IFigure>();
    private boolean validating;
    private boolean updating;
    private RunnableChain afterUpdate;
    private boolean updateQueued;
    GraphicsSource currentGs = null;

    public void paintAll(GC gc) {
        if (!this.validating) {
            J2DGraphicsSource gs = new J2DGraphicsSource(gc);
            Rectangle rectGC = gc.getClipping();
            org.eclipse.draw2d.geometry.Rectangle rect = new org.eclipse.draw2d.geometry.Rectangle(rectGC.x, rectGC.y, rectGC.width, rectGC.height);
            Graphics graphics = gs.getGraphics(rect);
            if (graphics != null) {
                ((J2DGraphics)graphics).getGraphics2D().setColor(Color.red);
                ((J2DGraphics)graphics).getGraphics2D().fillRect(0, 0, rect.width, rect.height);
                if (!this.updating) {
                    org.eclipse.draw2d.geometry.Rectangle rect2 = graphics.getClip(new org.eclipse.draw2d.geometry.Rectangle());
                    HashMap<IFigure, org.eclipse.draw2d.geometry.Rectangle> map = new HashMap<IFigure, org.eclipse.draw2d.geometry.Rectangle>();
                    map.put(this.rootFigure, rect2);
                    this.firePainting(rect, map);
                }
                this.performValidation();
                this.rootFigure.paint(graphics);
                gs.flushGraphics(rect);
                graphics.dispose();
            }
        } else {
            this.addDirtyRegion(this.rootFigure, new org.eclipse.draw2d.geometry.Rectangle(gc.getClipping()));
        }
    }

    public void setRoot(IFigure figure) {
        this.rootFigure = figure;
        super.setRoot(figure);
    }

    public void performValidation() {
        if (this.invalidFigures.isEmpty() || this.validating) {
            return;
        }
        try {
            this.validating = true;
            this.fireValidating();
            int i = 0;
            while (i < this.invalidFigures.size()) {
                IFigure fig = this.invalidFigures.get(i);
                this.invalidFigures.set(i, null);
                fig.validate();
                ++i;
            }
        }
        finally {
            this.invalidFigures.clear();
            this.validating = false;
        }
    }

    public synchronized void addInvalidFigure(IFigure f) {
        if (this.invalidFigures.contains(f)) {
            return;
        }
        this.queueWork();
        this.invalidFigures.add(f);
    }

    public synchronized void performUpdate() {
        if (this.isDisposed() || this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.performValidation();
            this.updateQueued = false;
            this.repairDamage();
            if (this.afterUpdate != null) {
                RunnableChain chain = this.afterUpdate;
                this.afterUpdate = null;
                chain.run();
                if (this.afterUpdate != null) {
                    this.queueWork();
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    public synchronized void runWithUpdate(Runnable runnable) {
        this.afterUpdate = new RunnableChain(runnable, this.afterUpdate);
        if (!this.updating) {
            this.queueWork();
        }
    }

    protected void queueWork() {
        if (!this.updateQueued) {
            this.sendUpdateRequest();
            this.updateQueued = true;
        }
    }

    private static class RunnableChain {
        RunnableChain next;
        Runnable run;

        RunnableChain(Runnable run, RunnableChain next) {
            this.run = run;
            this.next = next;
        }

        void run() {
            if (this.next != null) {
                this.next.run();
            }
            this.run.run();
        }
    }
}

