/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d;

import com.jaspersoft.studio.editor.java2d.ImageRenderer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class Win32ImageRenderer
implements ImageRenderer {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);

    static {
        System.loadLibrary("J2DWin32ImageRenderer");
    }

    @Override
    public final void render(Display paramDisplay, GC paramGC, int[] data, int xSrc, int ySrc, int width, int height, int xDest, int yDest, int imgWidth, int imgHeight) {
        try {
            Integer intParamGC = (Integer)Integer.class.cast(paramGC.handle);
            Win32ImageRenderer.renderImage(intParamGC, xDest, yDest, width, height, 0, 0, data, imgWidth, imgHeight);
        }
        catch (Throwable t) {
            System.out.println("Error: " + t.getMessage());
            System.out.flush();
            ImageData imageData = new ImageData(width, height, 32, PALETTE_DATA);
            imageData.setPixels(0, 0, data.length, data, 0);
            Image image = new Image((Device)paramDisplay, imageData);
            try {
                paramGC.drawImage(image, 0, 0, width, height, xDest, yDest, imgWidth, imgHeight);
                return;
            }
            finally {
                image.dispose();
            }
        }
    }

    public static native void renderImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int[] var7, int var8, int var9);
}

