/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout;

import com.jaspersoft.studio.editor.layout.AbstractLayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class HorizontalRowLayout
extends AbstractLayout {
    @Override
    public Map<JRElement, Rectangle> layout(JasperDesign jd, JRElementGroup container, JRElement[] elements, Dimension c) {
        HashMap<JRElement, Rectangle> map = new HashMap<JRElement, Rectangle>();
        int x = 0;
        int y = 0;
        int w = (int)Math.floor((float)c.width / (float)elements.length);
        int rest = c.width - w * elements.length;
        int h = c.height;
        JRElement[] jRElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JRElement el = jRElementArray[n2];
            JRDesignElement del = (JRDesignElement)el;
            map.put(el, new Rectangle(el.getX(), el.getY(), el.getWidth(), el.getHeight()));
            del.setX(x);
            del.setY(y);
            del.setWidth(w + rest);
            del.setHeight(h);
            x += w + rest;
            if (rest > 0) {
                rest = 0;
            }
            LayoutManager.layout(jd, map, el);
            ++n2;
        }
        return map;
    }

    @Override
    public String getName() {
        return Messages.HorizontalRowLayout_name;
    }

    @Override
    public String getToolTip() {
        return Messages.HorizontalRowLayout_toolTip;
    }

    @Override
    public String getIcon() {
        return "icons/layout-3.png";
    }

    @Override
    public boolean allowChildBoundChange(ANode resizedNode, Rectangle oldBounds, Rectangle newBounds) {
        return ModelUtils.safeEquals(oldBounds, newBounds);
    }

    @Override
    public Map<Object, Rectangle> getLayoutPosition(Object[] elements, int insertPosition, Dimension parentSize) {
        HashMap<Object, Rectangle> map = new HashMap<Object, Rectangle>();
        ArrayList<JRElement> jrElements = new ArrayList<JRElement>();
        ArrayList<JRField> jrFields = new ArrayList<JRField>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (el instanceof JRElement) {
                jrElements.add((JRElement)el);
            } else if (el instanceof JRField) {
                jrFields.add((JRField)el);
            }
            ++n2;
        }
        if (jrFields.isEmpty()) {
            int x = 0;
            int y = 0;
            int w = (int)Math.floor((float)parentSize.width / (float)elements.length);
            int rest = parentSize.width - w * elements.length;
            int h = parentSize.height;
            Object[] objectArray2 = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                Object rawEl = objectArray2[n4];
                if (rawEl instanceof JRElement) {
                    JRElement el = (JRElement)rawEl;
                    map.put(el, new Rectangle(x, y, w + rest, h));
                    x += w + rest;
                    if (rest > 0) {
                        rest = 0;
                    }
                }
                ++n4;
            }
        } else if (insertPosition >= 0) {
            int x = 0;
            int h = parentSize.height;
            int i = 0;
            while (i < insertPosition) {
                Object el = elements[i];
                if (el instanceof JRElement) {
                    x += ((JRElement)el).getWidth();
                }
                ++i;
            }
            map.put(jrFields.get(0), new Rectangle(x - 2, 0, 4, h));
        }
        return map;
    }

    @Override
    public int getInsertPosition(ANode container, Point dropPosition) {
        int index = 0;
        int offsetLeft = 0;
        if (container instanceof MBand) {
            offsetLeft += container.getJasperDesign().getLeftMargin();
        }
        for (INode child : container.getChildren()) {
            JRDesignElement jrChild = (JRDesignElement)child.getValue();
            if (jrChild.getY() < dropPosition.y && dropPosition.y < jrChild.getY() + jrChild.getHeight()) {
                int x = jrChild.getX() + offsetLeft;
                int span1 = x - 5;
                int span2 = x + 5;
                if (dropPosition.x > span1 && dropPosition.x < span2) {
                    return index;
                }
                if (dropPosition.x > (span1 += jrChild.getWidth()) && dropPosition.x < (span2 += jrChild.getWidth())) {
                    if (index < container.getChildren().size()) {
                        return index + 1;
                    }
                    return -1;
                }
            }
            ++index;
        }
        return -1;
    }
}

