/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout;

import com.jaspersoft.studio.editor.action.layout.LayoutAction;
import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.HorizontalRowLayout;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.editor.layout.grid.JSSGridBagLayout;
import com.jaspersoft.studio.editor.layout.spreadsheet.SpreadsheetLayout;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.property.metadata.PropertyMetadataRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.properties.PropertyMetadata;
import net.sf.jasperreports.properties.StandardPropertyMetadata;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchPart;

public class LayoutManager {
    private static final Class<?>[] layouts = new Class[]{HorizontalRowLayout.class, VerticalRowLayout.class, JSSGridBagLayout.class, SpreadsheetLayout.class};
    private static ILayout[] LAYOUTNAMES;
    private static Map<String, ILayout> layoutsMap;

    public static void initMetadata() {
        ArrayList<PropertyMetadata> pm = new ArrayList<PropertyMetadata>();
        StandardPropertyMetadata spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.studio.layout");
        spm.setLabel("Layout");
        spm.setDescription("Container Layout");
        spm.setValueType(Class.class.getName());
        ArrayList<PropertyScope> scopes = new ArrayList<PropertyScope>();
        scopes.add(PropertyScope.FRAME);
        scopes.add(PropertyScope.BAND);
        scopes.add(PropertyScope.CROSSTAB_CELL);
        scopes.add(PropertyScope.TABLE_CELL);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.layout.grid.x");
        spm.setLabel("Grid x");
        spm.setDescription("The key used to store the column position");
        spm.setValueType(Integer.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.ELEMENT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.layout.grid.y");
        spm.setLabel("Grid y");
        spm.setDescription("The key used to store the row position");
        spm.setValueType(Integer.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.ELEMENT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.layout.grid.colspan");
        spm.setLabel("Column Span");
        spm.setDescription("The key used to store the column span");
        spm.setValueType(Integer.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.ELEMENT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.layout.grid.rowspan");
        spm.setLabel("Row Span");
        spm.setDescription("The key used to store the row span");
        spm.setValueType(Integer.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.ELEMENT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.layout.grid.weight.x");
        spm.setLabel("Column Weight");
        spm.setDescription("The key used to store the column weight");
        spm.setValueType(Float.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.ELEMENT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.layout.grid.weight.y");
        spm.setLabel("Row Weight");
        spm.setDescription("The key used to store the row weight");
        spm.setValueType(Float.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.ELEMENT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.layout.grid.weight.fixed");
        spm.setLabel("Is Fixed");
        spm.setDescription("The key used to store the property for the fixed size of the element");
        spm.setValueType(Boolean.class.getName());
        scopes = new ArrayList();
        scopes.add(PropertyScope.ELEMENT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.designer:layout");
        pm.add((PropertyMetadata)spm);
        PropertyMetadataRegistry.addMetadata(pm);
    }

    public static ILayout getLayout(JRPropertiesHolder[] elements, JasperDesign jDesign, String uuid) {
        return LayoutManager.getLayout(elements, jDesign, uuid, new FreeLayout());
    }

    public static ILayout getLayout(JRPropertiesHolder[] elements, JasperDesign jDesign, String uuid, ILayout def) {
        String prop;
        JRPropertiesHolder[] jRPropertiesHolderArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String prop2;
            JRPropertiesHolder pholder = jRPropertiesHolderArray[n2];
            if (pholder != null && pholder.getPropertiesMap() != null && (prop2 = pholder.getPropertiesMap().getProperty("com.jaspersoft.studio.layout")) != null) {
                return LayoutManager.instLayout(prop2);
            }
            ++n2;
        }
        if (uuid != null && jDesign != null && (prop = jDesign.getPropertiesMap().getProperty("com.jaspersoft.studio.layout." + uuid)) != null) {
            return LayoutManager.instLayout(prop);
        }
        return def;
    }

    public static ILayout instLayout(String prop) {
        try {
            return (ILayout)Class.forName(prop).newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return new FreeLayout();
    }

    public static void addActions(ActionRegistry registry, IWorkbenchPart part, List<String> selectionActions) {
        LayoutAction action = new LayoutAction(part, FreeLayout.class);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        Class<?>[] classArray = layouts;
        int n = layouts.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> id = classArray[n2];
            action = new LayoutAction(part, id);
            registry.registerAction((IAction)action);
            selectionActions.add(action.getId());
            ++n2;
        }
    }

    public static void addMenu(MenuManager submenu, ActionRegistry actionRegistry) {
        IAction action = actionRegistry.getAction((Object)FreeLayout.class.getName());
        if (action.isEnabled()) {
            submenu.add(action);
        }
        Class<?>[] classArray = layouts;
        int n = layouts.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> id = classArray[n2];
            action = actionRegistry.getAction((Object)id.getName());
            if (action.isEnabled()) {
                submenu.add(action);
            }
            ++n2;
        }
    }

    public static ILayout[] getAllLayouts() {
        if (LAYOUTNAMES == null) {
            LAYOUTNAMES = new ILayout[]{new FreeLayout(), new HorizontalRowLayout(), new VerticalRowLayout(), new JSSGridBagLayout(), new SpreadsheetLayout()};
            layoutsMap = new HashMap<String, ILayout>();
            ILayout[] iLayoutArray = LAYOUTNAMES;
            int n = LAYOUTNAMES.length;
            int n2 = 0;
            while (n2 < n) {
                ILayout layout = iLayoutArray[n2];
                layoutsMap.put(layout.getClass().getName(), layout);
                ++n2;
            }
        }
        return LAYOUTNAMES;
    }

    public static ILayout getLayout(String className) {
        LayoutManager.getAllLayouts();
        return layoutsMap.get(className);
    }

    public static Map<JRElement, Rectangle> layout(JasperDesign jd, Map<JRElement, Rectangle> map, JRElement el) {
        if (el instanceof JRElementGroup && el instanceof JRPropertiesHolder) {
            Dimension d = null;
            if (el instanceof JRCommonElement) {
                JRElement jce = el;
                d = new Dimension(jce.getWidth(), jce.getHeight());
            }
            ILayout layout = LayoutManager.getLayout(new JRPropertiesHolder[]{el}, null, null);
            JRElementGroup group = (JRElementGroup)el;
            layout.layout(jd, group, group.getElements(), d);
        }
        return map;
    }

    public static JRPropertiesHolder getPropertyHolder(ANode node) {
        JRPropertiesHolder[] holders;
        if (node != null && node.getValue() instanceof JRPropertiesHolder) {
            return (JRPropertiesHolder)node.getValue();
        }
        if (node instanceof IContainerLayout && (holders = ((IContainerLayout)((Object)node)).getPropertyHolder()).length > 0) {
            return holders[0];
        }
        return null;
    }

    public static JRPropertiesMap getPropertyMap(ANode node) {
        if (node != null) {
            APropertyNode aNode;
            Object map;
            if (node instanceof APropertyNode && (map = (aNode = (APropertyNode)node).getPropertyValue("PROPERTY_MAP")) != null) {
                return (JRPropertiesMap)map;
            }
            if (node.getValue() instanceof JRPropertiesMap) {
                return (JRPropertiesMap)node.getValue();
            }
            JRPropertiesHolder pholder = LayoutManager.getPropertyHolder(node);
            if (pholder != null) {
                return pholder.getPropertiesMap();
            }
        }
        return null;
    }

    public static Class<? extends ILayout> getContainerLayout(ANode container) {
        if (container == null) {
            return FreeLayout.class;
        }
        JRPropertiesMap map = LayoutManager.getPropertyMap(container);
        if (map != null) {
            ILayout layout;
            String str = map.getProperty("com.jaspersoft.studio.layout");
            if (str == null) {
                ILayout defLayout;
                if (container instanceof IContainerLayout && (defLayout = ((IContainerLayout)((Object)container)).getDefaultLayout()) != null) {
                    str = defLayout.getClass().getName();
                }
                if (str == null) {
                    str = FreeLayout.class.getName();
                }
            }
            return (layout = LayoutManager.getLayout(str)) != null ? layout.getClass() : FreeLayout.class;
        }
        return FreeLayout.class;
    }

    public static Dimension getPaddedSize(IGraphicElementContainer containerToLayout) {
        int height;
        Dimension d = containerToLayout.getSize();
        int width = d.width - (Integer)Misc.nvl((Object)containerToLayout.getLeftPadding(), (Object)0) - (Integer)Misc.nvl((Object)containerToLayout.getRightPadding(), (Object)0);
        if (width < 0) {
            width = 0;
        }
        if ((height = d.height - (Integer)Misc.nvl((Object)containerToLayout.getTopPadding(), (Object)0) - (Integer)Misc.nvl((Object)containerToLayout.getBottomPadding(), (Object)0)) < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public static Dimension getPaddedSize(JRCommonElement jce) {
        if (jce instanceof JRLineBox) {
            Dimension d = new Dimension(jce.getWidth(), jce.getHeight());
            return LayoutManager.getPaddedSize((JRLineBox)jce, d);
        }
        if (jce instanceof JRBoxContainer) {
            Dimension d = new Dimension(jce.getWidth(), jce.getHeight());
            return LayoutManager.getPaddedSize((JRBoxContainer)jce, d);
        }
        return new Dimension(jce.getWidth(), jce.getHeight());
    }

    public static Pair<Dimension, JRLineBox> getPaddedSizeAndBox(JRCommonElement jce) {
        if (jce instanceof JRLineBox) {
            Dimension d = new Dimension(jce.getWidth(), jce.getHeight());
            return new Pair((Object)LayoutManager.getPaddedSize((JRLineBox)jce, d), (Object)((JRLineBox)jce));
        }
        if (jce instanceof JRBoxContainer) {
            JRBoxContainer boxContainer = (JRBoxContainer)jce;
            Dimension d = new Dimension(jce.getWidth(), jce.getHeight());
            return new Pair((Object)LayoutManager.getPaddedSize(boxContainer, d), (Object)boxContainer.getLineBox());
        }
        return new Pair((Object)new Dimension(jce.getWidth(), jce.getHeight()), null);
    }

    public static Dimension getPaddedSize(JRLineBox lineBox, Dimension baseSize) {
        int height;
        if (lineBox == null) {
            return baseSize;
        }
        int width = baseSize.width - (Integer)Misc.nvl((Object)lineBox.getLeftPadding(), (Object)0) - (Integer)Misc.nvl((Object)lineBox.getRightPadding(), (Object)0);
        if (width < 0) {
            width = 0;
        }
        if ((height = baseSize.height - (Integer)Misc.nvl((Object)lineBox.getTopPadding(), (Object)0) - (Integer)Misc.nvl((Object)lineBox.getBottomPadding(), (Object)0)) < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public static Dimension getPaddedSize(JRBoxContainer boxContainer, Dimension baseSize) {
        if (boxContainer == null) {
            return baseSize;
        }
        return LayoutManager.getPaddedSize(boxContainer.getLineBox(), baseSize);
    }

    public static LayoutCommand createRelayoutCommand(ANode containerToLayout) {
        if (containerToLayout == null) {
            return null;
        }
        Object jrElement = containerToLayout.getValue();
        JRElementGroup jrGroup = null;
        if (containerToLayout instanceof IGroupElement) {
            jrGroup = ((IGroupElement)((Object)containerToLayout)).getJRElementGroup();
        } else if (containerToLayout.getValue() instanceof JRElementGroup) {
            jrGroup = (JRElementGroup)containerToLayout.getValue();
        }
        Dimension d = new Dimension();
        if (containerToLayout instanceof IGraphicElementContainer) {
            d = LayoutManager.getPaddedSize((IGraphicElementContainer)((Object)containerToLayout));
        }
        if (jrElement instanceof JRCommonElement) {
            d = LayoutManager.getPaddedSize((JRCommonElement)jrElement);
        } else if (jrElement instanceof JRDesignBand) {
            JasperDesign jDesign = containerToLayout.getJasperDesign();
            int w = jDesign.getPageWidth() - jDesign.getLeftMargin() - jDesign.getRightMargin();
            d.setSize(new Dimension(w, ((JRDesignBand)jrElement).getHeight()));
        }
        JRPropertiesMap map = LayoutManager.getPropertyMap(containerToLayout);
        if (map != null && jrGroup != null) {
            String str = map.getProperty("com.jaspersoft.studio.layout");
            if (str == null) {
                ILayout defLayout;
                if (containerToLayout instanceof IContainerLayout && (defLayout = ((IContainerLayout)((Object)containerToLayout)).getDefaultLayout()) != null) {
                    str = defLayout.getClass().getName();
                }
                if (str == null) {
                    str = FreeLayout.class.getName();
                }
            }
            ILayout parentLayout = LayoutManager.getLayout(str);
            return new LayoutCommand(containerToLayout.getJasperDesign(), jrGroup, parentLayout, d);
        }
        return null;
    }

    public static void layoutContainer(ANode containerToLayout) {
        LayoutCommand cmd = LayoutManager.createRelayoutCommand(containerToLayout);
        if (cmd != null) {
            cmd.execute();
        }
    }

    public static Map<Object, Rectangle> createLayoutPosition(ANode containerToLayout, int insertPosition, List<Object> additionalElements) {
        JRPropertiesMap map;
        if (containerToLayout == null) {
            return null;
        }
        Object jrElement = containerToLayout.getValue();
        JRElementGroup jrGroup = null;
        if (containerToLayout instanceof IGroupElement) {
            jrGroup = ((IGroupElement)((Object)containerToLayout)).getJRElementGroup();
        } else if (containerToLayout.getValue() instanceof JRElementGroup) {
            jrGroup = (JRElementGroup)containerToLayout.getValue();
        }
        Dimension d = new Dimension();
        int topPadding = 0;
        int leftPadding = 0;
        if (containerToLayout instanceof IGraphicElementContainer) {
            IGraphicElementContainer graphContainer = (IGraphicElementContainer)((Object)containerToLayout);
            d = LayoutManager.getPaddedSize(graphContainer);
            topPadding = (Integer)Misc.nvl((Object)graphContainer.getTopPadding(), (Object)0);
            leftPadding = (Integer)Misc.nvl((Object)graphContainer.getLeftPadding(), (Object)0);
        }
        if (jrElement instanceof JRCommonElement) {
            Pair<Dimension, JRLineBox> sizeAndBox = LayoutManager.getPaddedSizeAndBox((JRCommonElement)jrElement);
            d = (Dimension)sizeAndBox.getKey();
            if (sizeAndBox.getValue() != null) {
                topPadding = (Integer)Misc.nvl((Object)((JRLineBox)sizeAndBox.getValue()).getTopPadding(), (Object)0);
                leftPadding = (Integer)Misc.nvl((Object)((JRLineBox)sizeAndBox.getValue()).getLeftPadding(), (Object)0);
            }
        } else if (jrElement instanceof JRDesignBand) {
            JasperDesign jDesign = containerToLayout.getJasperDesign();
            int w = jDesign.getPageWidth() - jDesign.getLeftMargin() - jDesign.getRightMargin();
            d.setSize(new Dimension(w, ((JRDesignBand)jrElement).getHeight()));
        }
        if ((map = LayoutManager.getPropertyMap(containerToLayout)) != null && jrGroup != null) {
            String str = map.getProperty("com.jaspersoft.studio.layout");
            if (str == null) {
                ILayout defLayout;
                if (containerToLayout instanceof IContainerLayout && (defLayout = ((IContainerLayout)((Object)containerToLayout)).getDefaultLayout()) != null) {
                    str = defLayout.getClass().getName();
                }
                if (str == null) {
                    str = FreeLayout.class.getName();
                }
            }
            ILayout parentLayout = LayoutManager.getLayout(str);
            ArrayList<Object> elements = new ArrayList<Object>();
            JRElement[] childElements = jrGroup.getElements();
            if (insertPosition < 0 || insertPosition >= jrGroup.getElements().length) {
                JRElement[] jRElementArray = childElements;
                int n = childElements.length;
                int n2 = 0;
                while (n2 < n) {
                    JRElement element = jRElementArray[n2];
                    elements.add(element);
                    ++n2;
                }
                elements.addAll(additionalElements);
            } else {
                int i = 0;
                while (i < childElements.length && i < insertPosition) {
                    elements.add(childElements[i]);
                    ++i;
                }
                elements.addAll(additionalElements);
                i = insertPosition;
                while (i < childElements.length) {
                    elements.add(childElements[i]);
                    ++i;
                }
            }
            Map<Object, Rectangle> result = parentLayout.getLayoutPosition(elements.toArray(new Object[elements.size()]), insertPosition, d);
            if (result != null && (topPadding != 0 || leftPadding != 0)) {
                for (Rectangle rect : result.values()) {
                    rect.setX(rect.x + leftPadding);
                    rect.setY(rect.y + topPadding);
                }
            }
            return result;
        }
        return null;
    }
}

