/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout;

import com.jaspersoft.studio.editor.layout.AbstractLayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignBreak;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class VerticalRowLayout
extends AbstractLayout {
    @Override
    public Map<JRElement, Rectangle> layout(JasperDesign jd, JRElementGroup container, JRElement[] elements, Dimension c) {
        HashMap<JRElement, Rectangle> map = new HashMap<JRElement, Rectangle>();
        int x = 0;
        int y = 0;
        int w = c.width;
        int breakNumbers = 0;
        JRElement[] jRElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JRElement el = jRElementArray[n2];
            if (el instanceof JRDesignBreak) {
                ++breakNumbers;
            }
            ++n2;
        }
        int h = (int)Math.floor((float)c.height / (float)(elements.length - breakNumbers)) - breakNumbers;
        int rest = c.height - h * (elements.length - breakNumbers) - breakNumbers;
        JRElement[] jRElementArray2 = elements;
        int n3 = elements.length;
        int n4 = 0;
        while (n4 < n3) {
            JRElement el = jRElementArray2[n4];
            JRDesignElement del = (JRDesignElement)el;
            map.put(el, new Rectangle(el.getX(), el.getY(), el.getWidth(), el.getHeight()));
            if (del instanceof JRDesignBreak) {
                del.setX(x);
                del.setY(y);
                del.setWidth(w);
                ++y;
            } else {
                del.setX(x);
                del.setY(y);
                del.setWidth(w);
                del.setHeight(h + rest);
                y += h + rest;
                if (rest > 0) {
                    rest = 0;
                }
                LayoutManager.layout(jd, map, el);
            }
            ++n4;
        }
        return map;
    }

    @Override
    public String getName() {
        return Messages.VerticalRowLayout_name;
    }

    @Override
    public String getToolTip() {
        return Messages.VerticalRowLayout_tooltip;
    }

    @Override
    public String getIcon() {
        return "icons/layout-h.png";
    }

    @Override
    public boolean allowChildBoundChange(ANode resizedNode, Rectangle oldBounds, Rectangle newBounds) {
        return ModelUtils.safeEquals(oldBounds, newBounds);
    }

    @Override
    public Map<Object, Rectangle> getLayoutPosition(Object[] elements, int insertPosition, Dimension parentSize) {
        HashMap<Object, Rectangle> map = new HashMap<Object, Rectangle>();
        ArrayList<JRElement> jrElements = new ArrayList<JRElement>();
        ArrayList<JRField> jrFields = new ArrayList<JRField>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (el instanceof JRElement) {
                jrElements.add((JRElement)el);
            } else if (el instanceof JRField) {
                jrFields.add((JRField)el);
            }
            ++n2;
        }
        if (jrFields.isEmpty()) {
            int x = 0;
            int y = 0;
            int w = parentSize.width;
            int h = (int)Math.floor((float)parentSize.height / (float)elements.length);
            int rest = parentSize.height - h * elements.length;
            Object[] objectArray2 = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                Object rawEl = objectArray2[n4];
                if (rawEl instanceof JRElement) {
                    JRElement el = (JRElement)rawEl;
                    map.put(el, new Rectangle(x, y, w, h + rest));
                    y += h + rest;
                    if (rest > 0) {
                        rest = 0;
                    }
                }
                ++n4;
            }
        } else if (insertPosition >= 0) {
            int y = 0;
            int w = parentSize.width;
            int i = 0;
            while (i < insertPosition) {
                Object el = elements[i];
                if (el instanceof JRElement) {
                    y += ((JRElement)el).getHeight();
                }
                ++i;
            }
            map.put(jrFields.get(0), new Rectangle(0, y - 2, w, 4));
        }
        return map;
    }

    @Override
    public int getInsertPosition(ANode container, Point dropPosition) {
        int index = 0;
        int offsetLeft = 0;
        if (container instanceof MBand) {
            offsetLeft += container.getJasperDesign().getLeftMargin();
        }
        for (INode child : container.getChildren()) {
            JRDesignElement jrChild = (JRDesignElement)child.getValue();
            if (jrChild.getX() + offsetLeft < dropPosition.x && dropPosition.x < jrChild.getX() + jrChild.getWidth()) {
                int y = jrChild.getY();
                int span1 = y - 5;
                int span2 = y + 5;
                if (dropPosition.y > span1 && dropPosition.y < span2) {
                    return index;
                }
                if (dropPosition.y > (span1 += jrChild.getHeight()) && dropPosition.y < (span2 += jrChild.getHeight())) {
                    if (index < container.getChildren().size()) {
                        return index + 1;
                    }
                    return -1;
                }
            }
            ++index;
        }
        return -1;
    }
}

