/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout.grid;

import com.jaspersoft.studio.editor.layout.grid.GridBagConstraints;
import com.jaspersoft.studio.editor.layout.grid.GridBagLayoutInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import org.eclipse.draw2d.geometry.Dimension;

public class GridBagLayoutUtil {
    static final int EMPIRICMULTIPLIER = 2;
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable<JRElement, GridBagConstraints> comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;

    public void setConstraints(JRElement comp) {
        boolean value;
        GridBagConstraints constraint = new GridBagConstraints();
        String prop = comp.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.x");
        constraint.gridx = this.parsePosition(prop);
        if (constraint.gridx > 250) {
            constraint.gridx = 250;
        }
        prop = comp.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.y");
        constraint.gridy = this.parsePosition(prop);
        if (constraint.gridy > 1000) {
            constraint.gridy = 1000;
        }
        prop = comp.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.rowspan");
        constraint.gridheight = this.parseSpan(prop);
        if (constraint.gridheight > 1000) {
            constraint.gridheight = 1000;
        }
        prop = comp.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.colspan");
        constraint.gridwidth = this.parseSpan(prop);
        if (constraint.gridwidth > 250) {
            constraint.gridwidth = 250;
        }
        boolean bl = value = (prop = comp.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.fixed")) != null ? Boolean.parseBoolean(prop.toString()) : false;
        if (value) {
            constraint.isFixedSeize = true;
            constraint.fill = 0;
            constraint.weightx = 0.0;
            constraint.weighty = 0.0;
            constraint.anchor = 18;
        } else {
            constraint.isFixedSeize = false;
            constraint.fill = 1;
            prop = comp.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.y");
            constraint.weighty = this.parseWeight(prop);
            prop = comp.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.x");
            constraint.weightx = this.parseWeight(prop);
        }
        this.comptable.put(comp, constraint);
    }

    protected double parseWeight(Object prop) {
        if (prop != null) {
            String value = prop.toString().trim();
            try {
                double result = Double.parseDouble(value);
                if (result >= 0.0) {
                    return result;
                }
            }
            catch (Exception exception) {}
        }
        return 1.0;
    }

    protected int parseSpan(Object prop) {
        if (prop != null) {
            String value = prop.toString().trim();
            try {
                int result = Integer.parseInt(value);
                if (result >= 1) {
                    return result;
                }
            }
            catch (Exception exception) {}
        }
        return 1;
    }

    protected int parsePosition(Object prop) {
        if (prop != null) {
            String value = prop.toString().trim();
            try {
                int result = Integer.parseInt(value);
                if (result >= 0) {
                    return result;
                }
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public GridBagConstraints getConstraints(JRElement comp) {
        GridBagConstraints constraints = this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp);
            constraints = this.comptable.get(comp);
        }
        return (GridBagConstraints)constraints.clone();
    }

    protected GridBagConstraints lookupConstraints(JRElement comp) {
        GridBagConstraints constraints = this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp);
            constraints = this.comptable.get(comp);
        }
        return constraints;
    }

    private void removeConstraints(JRElement comp) {
        this.comptable.remove(comp);
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] dim = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, dim[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, dim[1], 0, this.layoutInfo.height);
        return dim;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] weights = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, weights[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, weights[1], 0, this.layoutInfo.height);
        return weights;
    }

    public Point location(int x, int y) {
        Point loc = new Point(0, 0);
        if (this.layoutInfo == null) {
            return loc;
        }
        int d = this.layoutInfo.startx;
        int i = 0;
        while (i < this.layoutInfo.width) {
            if ((d += this.layoutInfo.minWidth[i]) > x) break;
            ++i;
        }
        loc.x = i;
        d = this.layoutInfo.starty;
        i = 0;
        while (i < this.layoutInfo.height) {
            if ((d += this.layoutInfo.minHeight[i]) > y) break;
            ++i;
        }
        loc.y = i;
        return loc;
    }

    public void removeLayoutComponent(JRElement comp) {
        this.removeConstraints(comp);
    }

    public Map<JRElement, org.eclipse.draw2d.geometry.Rectangle> layoutContainer(java.awt.Dimension parentSize, JRElement[] children) {
        return this.arrangeGrid(parentSize, children);
    }

    public Map<JRElement, org.eclipse.draw2d.geometry.Rectangle> layoutContainer(Dimension parentSize, JRElement[] children) {
        java.awt.Dimension dim = new java.awt.Dimension(parentSize.width, parentSize.height);
        return this.arrangeGrid(dim, children);
    }

    private long[] preInitMaximumArraySizes(JRElement[] child) {
        int preMaximumArrayXIndex = 0;
        int preMaximumArrayYIndex = 0;
        long[] returnArray = new long[2];
        int compId = 0;
        while (compId < child.length) {
            JRElement comp = child[compId];
            GridBagConstraints constraints = this.lookupConstraints(comp);
            int curX = constraints.gridx;
            int curY = constraints.gridy;
            int curWidth = constraints.gridwidth;
            int curHeight = constraints.gridheight;
            if (curX < 0) {
                curX = ++preMaximumArrayYIndex;
            }
            if (curY < 0) {
                curY = ++preMaximumArrayXIndex;
            }
            if (curWidth <= 0) {
                curWidth = 1;
            }
            if (curHeight <= 0) {
                curHeight = 1;
            }
            preMaximumArrayXIndex = Math.max(curY + curHeight, preMaximumArrayXIndex);
            preMaximumArrayYIndex = Math.max(curX + curWidth, preMaximumArrayYIndex);
            ++compId;
        }
        returnArray[0] = preMaximumArrayXIndex;
        returnArray[1] = preMaximumArrayYIndex;
        return returnArray;
    }

    protected GridBagLayoutInfo getLayoutInfo(java.awt.Dimension parentSize, JRElement[] child) {
        int py;
        int i;
        int px;
        GridBagConstraints constraints;
        JRElement comp;
        int curX = 0;
        int curY = 0;
        int curWidth = 1;
        int curHeight = 1;
        int maximumArrayXIndex = 0;
        int maximumArrayYIndex = 0;
        int layoutHeight = 0;
        int layoutWidth = 0;
        int curCol = -1;
        int curRow = -1;
        long[] arraySizes = this.preInitMaximumArraySizes(child);
        maximumArrayXIndex = 2L * arraySizes[0] > Integer.MAX_VALUE ? Integer.MAX_VALUE : 2 * (int)arraySizes[0];
        int n = maximumArrayYIndex = 2L * arraySizes[1] > Integer.MAX_VALUE ? Integer.MAX_VALUE : 2 * (int)arraySizes[1];
        if (this.rowHeights != null) {
            maximumArrayXIndex = Math.max(maximumArrayXIndex, this.rowHeights.length);
        }
        if (this.columnWidths != null) {
            maximumArrayYIndex = Math.max(maximumArrayYIndex, this.columnWidths.length);
        }
        int[] xMaxArray = new int[maximumArrayXIndex];
        int[] yMaxArray = new int[maximumArrayYIndex];
        int compindex = 0;
        while (compindex < child.length) {
            comp = child[compindex];
            constraints = this.lookupConstraints(comp);
            curX = constraints.gridx;
            curY = constraints.gridy;
            curWidth = constraints.gridwidth;
            if (curWidth <= 0) {
                curWidth = 1;
            }
            if ((curHeight = constraints.gridheight) <= 0) {
                curHeight = 1;
            }
            if (curX < 0 && curY < 0) {
                if (curRow >= 0) {
                    curY = curRow;
                } else if (curCol >= 0) {
                    curX = curCol;
                } else {
                    curY = 0;
                }
            }
            if (curX < 0) {
                px = 0;
                i = curY;
                while (i < curY + curHeight) {
                    px = Math.max(px, xMaxArray[i]);
                    ++i;
                }
                if ((curX = px - curX - 1) < 0) {
                    curX = 0;
                }
            } else if (curY < 0) {
                py = 0;
                i = curX;
                while (i < curX + curWidth) {
                    py = Math.max(py, yMaxArray[i]);
                    ++i;
                }
                if ((curY = py - curY - 1) < 0) {
                    curY = 0;
                }
            }
            curRow = curY;
            px = curX + curWidth;
            if (layoutWidth < px) {
                layoutWidth = px;
            }
            if (layoutHeight < (py = curY + curHeight)) {
                layoutHeight = py;
            }
            i = curX;
            while (i < curX + curWidth) {
                yMaxArray[i] = py;
                ++i;
            }
            i = curY;
            while (i < curY + curHeight) {
                xMaxArray[i] = px;
                ++i;
            }
            if (constraints.isFixedSeize) {
                constraints.minWidth = comp.getWidth();
                constraints.minHeight = comp.getHeight();
            } else {
                constraints.minWidth = 0;
                constraints.minHeight = 0;
            }
            ++compindex;
        }
        if (this.columnWidths != null && layoutWidth < this.columnWidths.length) {
            layoutWidth = this.columnWidths.length;
        }
        if (this.rowHeights != null && layoutHeight < this.rowHeights.length) {
            layoutHeight = this.rowHeights.length;
        }
        GridBagLayoutInfo r = new GridBagLayoutInfo(layoutWidth, layoutHeight);
        curCol = -1;
        curRow = -1;
        Arrays.fill(xMaxArray, 0);
        Arrays.fill(yMaxArray, 0);
        compindex = 0;
        while (compindex < child.length) {
            comp = child[compindex];
            constraints = this.lookupConstraints(comp);
            curX = constraints.gridx;
            curY = constraints.gridy;
            curWidth = constraints.gridwidth;
            curHeight = constraints.gridheight;
            if (curX < 0 && curY < 0) {
                if (curRow >= 0) {
                    curY = curRow;
                } else if (curCol >= 0) {
                    curX = curCol;
                } else {
                    curY = 0;
                }
            }
            if (curX < 0) {
                if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                    curHeight = 1;
                }
                px = 0;
                i = curY;
                while (i < curY + curHeight) {
                    px = Math.max(px, xMaxArray[i]);
                    ++i;
                }
                if ((curX = px - curX - 1) < 0) {
                    curX = 0;
                }
            } else if (curY < 0) {
                if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                    curWidth = 1;
                }
                py = 0;
                i = curX;
                while (i < curX + curWidth) {
                    py = Math.max(py, yMaxArray[i]);
                    ++i;
                }
                if ((curY = py - curY - 1) < 0) {
                    curY = 0;
                }
            }
            curRow = curY;
            if (curWidth <= 0 && (curWidth += r.width - curX) < 1) {
                curWidth = 1;
            }
            if (curHeight <= 0 && (curHeight += r.height - curY) < 1) {
                curHeight = 1;
            }
            px = curX + curWidth;
            py = curY + curHeight;
            i = curX;
            while (i < curX + curWidth) {
                yMaxArray[i] = py;
                ++i;
            }
            i = curY;
            while (i < curY + curHeight) {
                xMaxArray[i] = px;
                ++i;
            }
            constraints.tempX = curX;
            constraints.tempY = curY;
            constraints.tempWidth = curWidth;
            constraints.tempHeight = curHeight;
            ++compindex;
        }
        r.weightX = new double[maximumArrayYIndex];
        r.weightY = new double[maximumArrayXIndex];
        r.minWidth = new int[maximumArrayYIndex];
        r.minHeight = new int[maximumArrayXIndex];
        if (this.columnWidths != null) {
            System.arraycopy(this.columnWidths, 0, r.minWidth, 0, this.columnWidths.length);
        }
        if (this.rowHeights != null) {
            System.arraycopy(this.rowHeights, 0, r.minHeight, 0, this.rowHeights.length);
        }
        if (this.columnWeights != null) {
            System.arraycopy(this.columnWeights, 0, r.weightX, 0, Math.min(r.weightX.length, this.columnWeights.length));
        }
        if (this.rowWeights != null) {
            System.arraycopy(this.rowWeights, 0, r.weightY, 0, Math.min(r.weightY.length, this.rowWeights.length));
        }
        int nextSize = Integer.MAX_VALUE;
        i = 1;
        while (i != Integer.MAX_VALUE) {
            compindex = 0;
            while (compindex < child.length) {
                int pixels_diff;
                double wt;
                double weight;
                int k;
                double weight_diff;
                comp = child[compindex];
                constraints = this.lookupConstraints(comp);
                if (constraints.tempWidth == i) {
                    px = constraints.tempX + constraints.tempWidth;
                    weight_diff = constraints.weightx;
                    k = constraints.tempX;
                    while (k < px) {
                        weight_diff -= r.weightX[k];
                        ++k;
                    }
                    if (weight_diff > 0.0) {
                        weight = 0.0;
                        k = constraints.tempX;
                        while (k < px) {
                            weight += r.weightX[k];
                            ++k;
                        }
                        k = constraints.tempX;
                        while (weight > 0.0 && k < px) {
                            wt = r.weightX[k];
                            double dx = wt * weight_diff / weight;
                            int n2 = k++;
                            r.weightX[n2] = r.weightX[n2] + dx;
                            weight_diff -= dx;
                            weight -= wt;
                        }
                        int n3 = px - 1;
                        r.weightX[n3] = r.weightX[n3] + weight_diff;
                    }
                    pixels_diff = constraints.minWidth + constraints.ipadx + constraints.insets.left + constraints.insets.right;
                    k = constraints.tempX;
                    while (k < px) {
                        pixels_diff -= r.minWidth[k];
                        ++k;
                    }
                    if (pixels_diff > 0) {
                        weight = 0.0;
                        k = constraints.tempX;
                        while (k < px) {
                            weight += r.weightX[k];
                            ++k;
                        }
                        k = constraints.tempX;
                        while (weight > 0.0 && k < px) {
                            wt = r.weightX[k];
                            int dx = (int)(wt * (double)pixels_diff / weight);
                            int n4 = k++;
                            r.minWidth[n4] = r.minWidth[n4] + dx;
                            pixels_diff -= dx;
                            weight -= wt;
                        }
                        int n5 = px - 1;
                        r.minWidth[n5] = r.minWidth[n5] + pixels_diff;
                    }
                } else if (constraints.tempWidth > i && constraints.tempWidth < nextSize) {
                    nextSize = constraints.tempWidth;
                }
                if (constraints.tempHeight == i) {
                    py = constraints.tempY + constraints.tempHeight;
                    weight_diff = constraints.weighty;
                    k = constraints.tempY;
                    while (k < py) {
                        weight_diff -= r.weightY[k];
                        ++k;
                    }
                    if (weight_diff > 0.0) {
                        weight = 0.0;
                        k = constraints.tempY;
                        while (k < py) {
                            weight += r.weightY[k];
                            ++k;
                        }
                        k = constraints.tempY;
                        while (weight > 0.0 && k < py) {
                            wt = r.weightY[k];
                            double dy = wt * weight_diff / weight;
                            int n6 = k++;
                            r.weightY[n6] = r.weightY[n6] + dy;
                            weight_diff -= dy;
                            weight -= wt;
                        }
                        int n7 = py - 1;
                        r.weightY[n7] = r.weightY[n7] + weight_diff;
                    }
                    pixels_diff = constraints.minHeight + constraints.ipady + constraints.insets.top + constraints.insets.bottom;
                    k = constraints.tempY;
                    while (k < py) {
                        pixels_diff -= r.minHeight[k];
                        ++k;
                    }
                    if (pixels_diff > 0) {
                        weight = 0.0;
                        k = constraints.tempY;
                        while (k < py) {
                            weight += r.weightY[k];
                            ++k;
                        }
                        k = constraints.tempY;
                        while (weight > 0.0 && k < py) {
                            wt = r.weightY[k];
                            int dy = (int)(wt * (double)pixels_diff / weight);
                            int n8 = k++;
                            r.minHeight[n8] = r.minHeight[n8] + dy;
                            pixels_diff -= dy;
                            weight -= wt;
                        }
                        int n9 = py - 1;
                        r.minHeight[n9] = r.minHeight[n9] + pixels_diff;
                    }
                } else if (constraints.tempHeight > i && constraints.tempHeight < nextSize) {
                    nextSize = constraints.tempHeight;
                }
                ++compindex;
            }
            i = nextSize;
            nextSize = Integer.MAX_VALUE;
        }
        return r;
    }

    protected java.awt.Dimension getMinSize(java.awt.Dimension parentDimension, GridBagLayoutInfo info) {
        java.awt.Dimension d = new java.awt.Dimension();
        int t = 0;
        int i = 0;
        while (i < info.width) {
            t += info.minWidth[i];
            ++i;
        }
        d.width = t;
        t = 0;
        i = 0;
        while (i < info.height) {
            t += info.minHeight[i];
            ++i;
        }
        d.height = t;
        return d;
    }

    protected HashMap<JRElement, org.eclipse.draw2d.geometry.Rectangle> arrangeGrid(java.awt.Dimension parentSize, JRElement[] components) {
        int diffh;
        double weight;
        Rectangle r = new Rectangle();
        HashMap<JRElement, org.eclipse.draw2d.geometry.Rectangle> result = new HashMap<JRElement, org.eclipse.draw2d.geometry.Rectangle>();
        if (!(components.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return result;
        }
        GridBagLayoutInfo info = this.getLayoutInfo(parentSize, components);
        java.awt.Dimension d = this.getMinSize(parentSize, info);
        this.layoutInfo = info;
        r.width = d.width;
        r.height = d.height;
        int diffw = parentSize.width - r.width;
        if (diffw != 0) {
            Iterator iterator;
            weight = 0.0;
            HashSet<Integer> notFixedSizeCols = new HashSet<Integer>();
            int i = 0;
            while (i < info.width) {
                if ((double)info.minWidth[i] == 0.0) {
                    notFixedSizeCols.add(i);
                    weight += info.weightX[i];
                }
                ++i;
            }
            if (weight > 0.0) {
                iterator = notFixedSizeCols.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    int dx = (int)((double)diffw * info.weightX[i] / weight);
                    int n = i;
                    info.minWidth[n] = info.minWidth[n] + dx;
                    r.width += dx;
                    if (info.minWidth[i] >= 0) continue;
                    r.width -= info.minWidth[i];
                    info.minWidth[i] = 0;
                }
            }
            if ((diffw = parentSize.width - r.width) > 0 && !notFixedSizeCols.isEmpty()) {
                block2: while (diffw != 0) {
                    iterator = notFixedSizeCols.iterator();
                    while (iterator.hasNext()) {
                        int n = i = ((Integer)iterator.next()).intValue();
                        info.minWidth[n] = info.minWidth[n] + 1;
                        ++r.width;
                        if (--diffw == 0) continue block2;
                    }
                }
            }
        } else {
            diffw = 0;
        }
        if ((diffh = parentSize.height - r.height) != 0) {
            weight = 0.0;
            HashSet<Integer> notFixedSizeCols = new HashSet<Integer>();
            int i = 0;
            while (i < info.height) {
                if ((double)info.minHeight[i] == 0.0) {
                    notFixedSizeCols.add(i);
                    weight += info.weightY[i];
                }
                ++i;
            }
            if (weight > 0.0) {
                Iterator iterator = notFixedSizeCols.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    int dy = (int)((double)diffh * info.weightY[i] / weight);
                    int n = i;
                    info.minHeight[n] = info.minHeight[n] + dy;
                    r.height += dy;
                    if (info.minHeight[i] >= 0) continue;
                    r.height -= info.minHeight[i];
                    info.minHeight[i] = 0;
                }
            }
            if ((diffh = parentSize.height - r.height) > 0 && !notFixedSizeCols.isEmpty()) {
                block6: while (diffh != 0) {
                    Iterator iterator = notFixedSizeCols.iterator();
                    while (iterator.hasNext()) {
                        int n = i = ((Integer)iterator.next()).intValue();
                        info.minHeight[n] = info.minHeight[n] + 1;
                        ++r.height;
                        if (--diffh == 0) continue block6;
                    }
                }
            }
        } else {
            diffh = 0;
        }
        info.startx = 0;
        info.starty = 0;
        int compindex = 0;
        while (compindex < components.length) {
            JRElement comp = components[compindex];
            GridBagConstraints constraints = this.lookupConstraints(comp);
            r.x = info.startx;
            int i = 0;
            while (i < constraints.tempX) {
                r.x += info.minWidth[i];
                ++i;
            }
            r.y = info.starty;
            i = 0;
            while (i < constraints.tempY) {
                r.y += info.minHeight[i];
                ++i;
            }
            r.width = 0;
            i = constraints.tempX;
            while (i < constraints.tempX + constraints.tempWidth) {
                r.width += info.minWidth[i];
                ++i;
            }
            r.height = 0;
            i = constraints.tempY;
            while (i < constraints.tempY + constraints.tempHeight) {
                r.height += info.minHeight[i];
                ++i;
            }
            this.adjustForGravity(constraints, r);
            if (r.x < 0) {
                r.width += r.x;
                r.x = 0;
            }
            if (r.y < 0) {
                r.height += r.y;
                r.y = 0;
            }
            if (r.width <= 0 || r.height <= 0) {
                result.put(comp, new org.eclipse.draw2d.geometry.Rectangle(0, 0, 0, 0));
            } else if (comp.getX() != r.x || comp.getY() != r.y || comp.getWidth() != r.width || comp.getHeight() != r.height) {
                result.put(comp, new org.eclipse.draw2d.geometry.Rectangle(r.x, r.y, r.width, r.height));
            }
            ++compindex;
        }
        return result;
    }

    protected void adjustForGravity(GridBagConstraints constraints, Rectangle r) {
        r.x += constraints.insets.left;
        r.width -= constraints.insets.left + constraints.insets.right;
        r.y += constraints.insets.top;
        r.height -= constraints.insets.top + constraints.insets.bottom;
        int diffx = 0;
        if (constraints.fill != 2 && constraints.fill != 1 && r.width > constraints.minWidth + constraints.ipadx) {
            diffx = r.width - (constraints.minWidth + constraints.ipadx);
            r.width = constraints.minWidth + constraints.ipadx;
        }
        int diffy = 0;
        if (constraints.fill != 3 && constraints.fill != 1 && r.height > constraints.minHeight + constraints.ipady) {
            diffy = r.height - (constraints.minHeight + constraints.ipady);
            r.height = constraints.minHeight + constraints.ipady;
        }
        switch (constraints.anchor) {
            case 10: {
                r.x += diffx / 2;
                r.y += diffy / 2;
                break;
            }
            case 11: 
            case 19: {
                r.x += diffx / 2;
                break;
            }
            case 12: {
                r.x += diffx;
                break;
            }
            case 13: {
                r.x += diffx;
                r.y += diffy / 2;
                break;
            }
            case 14: {
                r.x += diffx;
                r.y += diffy;
                break;
            }
            case 15: 
            case 20: {
                r.x += diffx / 2;
                r.y += diffy;
                break;
            }
            case 16: {
                r.y += diffy;
                break;
            }
            case 17: {
                r.y += diffy / 2;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                r.y += diffy / 2;
                break;
            }
            case 22: {
                r.y += diffy / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }
}

