/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout.spreadsheet;

import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;

public class SpreadSheetElementsCache {
    private HashMap<String, List<JRDesignElement>> cacheMap = null;
    private JasperDesign jd;

    public SpreadSheetElementsCache(JasperDesign jd, MReport report) {
        this.jd = jd;
        report.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("children")) {
                    SpreadSheetElementsCache.this.cacheMap = null;
                }
            }
        });
    }

    public List<JRDesignElement> getElementsFor(String uuid) {
        if (this.cacheMap == null) {
            this.cacheMap = new HashMap();
            List<JRDesignElement> elements = ModelUtils.getAllElements(this.jd);
            for (JRDesignElement element : elements) {
                String elementUUID = element.getPropertiesMap().getProperty("com.jaspersoft.studio.spreadsheet.connectionID");
                if (elementUUID == null) continue;
                List<JRDesignElement> elementsList = this.cacheMap.get(elementUUID);
                if (elementsList == null) {
                    elementsList = new ArrayList<JRDesignElement>();
                    this.cacheMap.put(elementUUID, elementsList);
                }
                elementsList.add(element);
            }
        }
        return this.cacheMap.get(uuid);
    }
}

