/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.IGraphicalEditor;
import com.jaspersoft.studio.editor.action.CustomDeleteAction;
import com.jaspersoft.studio.editor.action.order.BringBackwardAction;
import com.jaspersoft.studio.editor.action.order.BringForwardAction;
import com.jaspersoft.studio.editor.dnd.ImageResourceDropTargetListener;
import com.jaspersoft.studio.editor.dnd.ImageURLTransfer;
import com.jaspersoft.studio.editor.dnd.JSSTemplateTransferDropTargetListener;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.java2d.J2DLightweightSystem;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.java2d.figure.JSSScrollableThumbnail;
import com.jaspersoft.studio.editor.menu.AppContextMenuProvider;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.EditorContributor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.util.EditPartVisitor;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.preferences.bindings.BindingsPreferencePersistence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ResourceTransfer;

public class JDReportOutlineView
extends ContentOutlinePage
implements IAdaptable {
    protected IGraphicalEditor editor;
    private PageBook pageBook;
    private Control outline;
    private Canvas overview;
    private IAction showOutlineAction;
    private IAction showOverviewAction;
    public static final String ID_ACTION_OUTLINE = "showOutlineAction";
    public static final String ID_ACTION_OVERVIEW = "showOverviewAction";
    private JSSScrollableThumbnail thumbnail;
    private DisposeListener disposeListener;
    private Point mousePosition = new Point(-1, -1);
    private boolean enableFocusFix = Util.isLinux();
    private PreferenceListener preferenceListener = new PreferenceListener();
    private EditorContributor editorContributor;
    private EditPartFactory editPartFactory;

    public JDReportOutlineView(IGraphicalEditor editor, EditPartViewer viewer) {
        super(viewer);
        this.editor = editor;
    }

    public IGraphicalEditor getEditor() {
        return this.editor;
    }

    public void init(IPageSite pageSite) {
        ANode n;
        super.init(pageSite);
        ActionRegistry registry = this.editor.getActionRegistry();
        IActionBars bars = pageSite.getActionBars();
        Iterator it = registry.getActions();
        while (it.hasNext()) {
            IAction ia = (IAction)it.next();
            if (ActionFactory.SAVE.getId().equals(ia.getId())) continue;
            bars.setGlobalActionHandler(ia.getId(), ia);
        }
        IResource r = null;
        if (this.editor.getModel() instanceof ANode && (n = (ANode)this.editor.getModel()).getJasperConfiguration() != null) {
            r = (IResource)n.getJasperConfiguration().get("ifile");
        }
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, r);
        bars.updateActionBars();
    }

    protected void initActions(ActionRegistry registry, IActionBars bars) {
    }

    protected ContextMenuProvider getMenuContentProvider() {
        return new AppContextMenuProvider(this.getViewer(), this.editor.getActionRegistry());
    }

    public boolean isDisposed() {
        return this.getViewer() == null || this.getViewer().getControl() == null || this.getViewer().getControl().isDisposed();
    }

    protected void configureOutlineViewer() {
        EditPartViewer viewer = this.getViewer();
        viewer.setEditDomain((EditDomain)this.editor.getEditDomain());
        viewer.setEditPartFactory(this.getEditPartFactory());
        ContextMenuProvider provider = this.getMenuContentProvider();
        viewer.setContextMenu((MenuManager)provider);
        viewer.addDropTargetListener((TransferDropTargetListener)new JSSTemplateTransferDropTargetListener(viewer));
        viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener(viewer){

            protected Object getTemplate() {
                ArrayList<Object> models = new ArrayList<Object>();
                Object obj = super.getTemplate();
                if (obj == null) {
                    List selection = this.getViewer().getSelectedEditParts();
                    for (Object it : selection) {
                        BandTypeEnum bandType;
                        if (!(it instanceof EditPart)) continue;
                        Object model = ((EditPart)it).getModel();
                        if (model instanceof IDragable) {
                            models.add(model);
                        }
                        if (!(model instanceof MBand) || !BandTypeEnum.DETAIL.equals((Object)(bandType = ((MBand)model).getBandType())) && !BandTypeEnum.GROUP_FOOTER.equals((Object)bandType) && !BandTypeEnum.GROUP_HEADER.equals((Object)bandType)) continue;
                        models.add(model);
                    }
                }
                return models;
            }
        });
        viewer.addDropTargetListener((TransferDropTargetListener)new ImageResourceDropTargetListener(viewer, (Transfer)ResourceTransfer.getInstance()));
        viewer.addDropTargetListener((TransferDropTargetListener)new ImageResourceDropTargetListener(viewer, (Transfer)FileTransfer.getInstance()));
        viewer.addDropTargetListener((TransferDropTargetListener)new ImageResourceDropTargetListener(viewer, (Transfer)ImageURLTransfer.getInstance()));
        IPageSite site = this.getSite();
        IToolBarManager tbm = site.getActionBars().getToolBarManager();
        this.registerToolbarAction(tbm);
        this.showPage(ID_ACTION_OUTLINE);
    }

    public void registerToolbarAction(IToolBarManager tbm) {
        IContributionItem[] items = tbm.getItems();
        HashSet<String> existingItems = new HashSet<String>();
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            existingItems.add(item.getId());
            ++n2;
        }
        this.showOutlineAction = new Action(){

            public void run() {
                JDReportOutlineView.this.showPage(JDReportOutlineView.ID_ACTION_OUTLINE);
            }
        };
        this.showOutlineAction.setId(ID_ACTION_OUTLINE);
        this.showOutlineAction.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/outline.gif"));
        this.showOutlineAction.setToolTipText(Messages.JDReportOutlineView_show_outline_tool_tip);
        if (!existingItems.contains(ID_ACTION_OUTLINE)) {
            ActionContributionItem showOutlineItem = new ActionContributionItem(this.showOutlineAction);
            showOutlineItem.setVisible(true);
            tbm.add((IContributionItem)showOutlineItem);
        }
        this.showOverviewAction = new Action(){

            public void run() {
                JDReportOutlineView.this.showPage(JDReportOutlineView.ID_ACTION_OVERVIEW);
            }
        };
        this.showOverviewAction.setId(ID_ACTION_OVERVIEW);
        this.showOverviewAction.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/overview.gif"));
        this.showOverviewAction.setToolTipText(Messages.JDReportOutlineView_show_overview_tool_tip);
        if (!existingItems.contains(ID_ACTION_OVERVIEW)) {
            ActionContributionItem showOverviewItem = new ActionContributionItem(this.showOverviewAction);
            showOverviewItem.setVisible(true);
            tbm.add((IContributionItem)showOverviewItem);
        }
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.outline = this.getViewer().createControl((Composite)this.pageBook);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.outline, "com.jaspersoft.studio.doc.view_outline");
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.pageBook.showPage(this.outline);
        this.configureOutlineViewer();
        this.hookOutlineViewer();
        this.setContents(this.editor.getModel());
        if (this.outline instanceof Tree) {
            final Tree tree = (Tree)this.outline;
            tree.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    JDReportOutlineView.this.mousePosition.setLocation(-1, -1);
                }

                public void focusGained(FocusEvent e) {
                    EditPart translatedPart;
                    EditPart part;
                    if (JDReportOutlineView.this.enableFocusFix && JDReportOutlineView.this.mousePosition.x != -1 && (part = JDReportOutlineView.this.getViewer().findObjectAt(JDReportOutlineView.this.mousePosition)) != null && part.getModel() instanceof MRoot && (translatedPart = JDReportOutlineView.this.getViewer().findObjectAt(new Point(JDReportOutlineView.this.mousePosition.x + 10, JDReportOutlineView.this.mousePosition.y))) != null && translatedPart.getModel() != part.getModel()) {
                        TreeItem item;
                        item.setExpanded(!(item = (TreeItem)((TreeEditPart)translatedPart).getWidget()).getExpanded());
                        tree.deselectAll();
                        tree.select(item);
                        tree.layout(true);
                    }
                }
            });
            tree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    Tree t;
                    TreeItem[] ti;
                    if (e.getSource() instanceof Tree && (ti = (t = (Tree)e.getSource()).getSelection()) != null && ti.length > 0) {
                        Object obj = ti[0].getData();
                        if (obj instanceof EditPart) {
                            EditPart part = (EditPart)obj;
                            SelectionRequest request = new SelectionRequest();
                            request.setType((Object)"open");
                            if (part.understandsRequest((Request)request)) {
                                part.performRequest((Request)request);
                                return;
                            }
                        }
                        if (ti.length == 1 && ti[0].getItemCount() > 0) {
                            ti[0].setExpanded(!ti[0].getExpanded());
                        }
                    }
                }
            });
            tree.addKeyListener((KeyListener)new KeyAdapter(){
                private static final String ACTION_UP_BINDING = "com.jaspersoft.studio.editor.action.order.BringForwardAction";
                private static final String ACTION_DOWN_BINDING = "com.jaspersoft.studio.editor.action.order.BringBackwardAction";

                public void keyPressed(KeyEvent e) {
                    if (BindingsPreferencePersistence.isPressed(ACTION_DOWN_BINDING)) {
                        BringForwardAction action = new BringForwardAction((IWorkbenchPart)((AbstractVisualEditor)JDReportOutlineView.this.getEditor()));
                        action.setLazyEnablementCalculation(true);
                        if (action.isEnabled()) {
                            action.run();
                        }
                    } else if (BindingsPreferencePersistence.isPressed(ACTION_UP_BINDING)) {
                        BringBackwardAction action = new BringBackwardAction((IWorkbenchPart)((AbstractVisualEditor)JDReportOutlineView.this.getEditor()));
                        action.setLazyEnablementCalculation(true);
                        if (action.isEnabled()) {
                            action.run();
                        }
                    } else if (e.keyCode == 8) {
                        CustomDeleteAction action = new CustomDeleteAction((IWorkbenchPart)((AbstractVisualEditor)JDReportOutlineView.this.getEditor()));
                        action.setSelectionProvider((ISelectionProvider)JDReportOutlineView.this.getViewer());
                        action.update();
                        if (action.isEnabled()) {
                            action.run();
                        }
                    }
                }
            });
            tree.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    JDReportOutlineView.this.mousePosition.setLocation(e.x, e.y);
                    EditPart part = JDReportOutlineView.this.getViewer().findObjectAt(new Point(e.x, e.y));
                    Tree t = (Tree)e.getSource();
                    if (part != null && part.getModel() != null && !(part.getModel() instanceof MRoot)) {
                        Object model = part.getModel();
                        String toolTipText = Misc.nvl((String)((ANode)model).getToolTip());
                        String displayText = Misc.nvl((String)((ANode)model).getDisplayText());
                        String text = "";
                        if (!toolTipText.isEmpty() && !toolTipText.equals(displayText)) {
                            text = String.valueOf(toolTipText) + "\n";
                        }
                        text = String.valueOf(text) + displayText;
                        t.setToolTipText(text);
                        return;
                    }
                    t.setToolTipText(null);
                }
            });
        }
    }

    public void dispose() {
        JaspersoftStudioPlugin.getInstance().removePreferenceListener(this.preferenceListener);
        this.unhookOutlineViewer();
        if (this.thumbnail != null) {
            this.thumbnail = null;
        }
        super.dispose();
    }

    public EditPartFactory getEditPartFactory() {
        if (this.editPartFactory == null) {
            this.editPartFactory = new OutlineTreeEditPartFactory();
        }
        return this.editPartFactory;
    }

    public void setEditPartFactory(EditPartFactory editPartFactory) {
        this.editPartFactory = editPartFactory;
        this.getViewer().setEditPartFactory(this.getEditPartFactory());
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return this.editor.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (type == EditorContributor.class) {
            if (this.editorContributor == null) {
                this.editorContributor = new EditorContributor((EditDomain)this.editor.getEditDomain());
            }
            return this.editorContributor;
        }
        return null;
    }

    public Control getControl() {
        return this.pageBook;
    }

    protected void hookOutlineViewer() {
        this.editor.getSelectionSynchronizer().addViewer(this.getViewer());
    }

    protected void initializeOverview() {
        J2DLightweightSystem lws = new J2DLightweightSystem(this.overview);
        RootEditPart rep = this.editor.getGraphicalViewer().getRootEditPart();
        if (rep instanceof MainDesignerRootEditPart) {
            MainDesignerRootEditPart root = (MainDesignerRootEditPart)rep;
            this.thumbnail = new JSSScrollableThumbnail((Viewport)root.getFigure(), (MRoot)this.getViewer().getContents().getModel());
            this.thumbnail.setSource(root.getLayer("Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (JDReportOutlineView.this.thumbnail != null) {
                        JDReportOutlineView.this.thumbnail.deactivate();
                        JDReportOutlineView.this.thumbnail = null;
                    }
                }
            };
            this.editor.getEditor().addDisposeListener(this.disposeListener);
        }
        lws.setControl(this.overview);
    }

    public void setContents(Object contents) {
        Tree tree;
        if (this.getViewer().getEditPartFactory() != null) {
            this.getViewer().deselectAll();
            this.getViewer().setContents(contents);
        }
        if (this.outline instanceof Tree && !(tree = (Tree)this.outline).isDisposed() && tree.getItems() != null && tree.getItems().length > 0) {
            tree.getItem(0).setExpanded(true);
        }
    }

    protected void showPage(String id) {
        if (ID_ACTION_OUTLINE.equals(id)) {
            this.showOutlineAction.setChecked(true);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage(this.outline);
            ((JSSScrollingGraphicalViewer)this.editor.getGraphicalViewer()).setPaintOnlyVisibleElements(true);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(false);
            }
        } else if (ID_ACTION_OVERVIEW.equals(id)) {
            ((JSSScrollingGraphicalViewer)this.editor.getGraphicalViewer()).setPaintOnlyVisibleElements(false);
            if (this.thumbnail == null) {
                this.initializeOverview();
            }
            this.showOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(true);
            this.pageBook.showPage((Control)this.overview);
            this.thumbnail.setVisible(true);
        }
    }

    protected void unhookOutlineViewer() {
        this.editor.getSelectionSynchronizer().removeViewer(this.getViewer());
        FigureCanvas editor2 = this.editor.getEditor();
        if (this.disposeListener != null && editor2 != null && !editor2.isDisposed()) {
            editor2.removeDisposeListener(this.disposeListener);
        }
    }

    public void setTreeSelection(ISelection s) {
        if (s != null && s instanceof StructuredSelection && this.outline instanceof Tree) {
            StructuredSelection sel = (StructuredSelection)s;
            List sobj = sel.toList();
            ArrayList<TreeItem> toSelect = new ArrayList<TreeItem>();
            Tree tree = (Tree)this.outline;
            tree.getItemCount();
            this.checkItems(tree.getItems(), toSelect, sobj);
            if (!toSelect.isEmpty()) {
                tree.setSelection(toSelect.toArray(new TreeItem[toSelect.size()]));
            }
        } else {
            this.setSelection(s);
        }
    }

    public void checkItems(TreeItem[] items, List<TreeItem> toSelect, List<?> sobj) {
        if (items == null) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            for (Object obj : sobj) {
                if (obj == null || ti.getData() == null) continue;
                if (obj == ti.getData()) {
                    toSelect.add(ti);
                    continue;
                }
                if (!(obj instanceof EditPart) || !(ti.getData() instanceof EditPart) || ((EditPart)obj).getModel() != ((EditPart)ti.getData()).getModel()) continue;
                toSelect.add(ti);
            }
            this.checkItems(ti.getItems(), toSelect, sobj);
            ++n2;
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("showVariablesDefault")) {
                RootEditPart rep = JDReportOutlineView.this.getViewer().getRootEditPart();
                new EditPartVisitor<String>((EditPart)rep){

                    @Override
                    public boolean visit(EditPart n) {
                        if (n.getModel() instanceof MParameters || n.getModel() instanceof MVariables) {
                            if (((TreeEditPart)n).getWidget() != null) {
                                n.refresh();
                            }
                            return false;
                        }
                        return true;
                    }
                };
            }
        }
    }
}

