/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.command.CreateBandDetailCommand;
import java.util.List;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateDetailBandAction
extends ACachedSelectionAction {
    public static final String ID = "create_detail_band";

    public CreateDetailBandAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    @Override
    protected boolean calculateEnabled() {
        List<Object> elements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        return elements.size() > 0 && this.getParentBand((ANode)elements.get(0)) != null;
    }

    @Override
    public Command createCommand() {
        List<Object> elements = this.editor.getSelectionCache().getSelectionModelForType(MBand.class);
        MBand current = null;
        if (elements.size() == 1) {
            current = (MBand)elements.get(0);
        } else {
            StructuredSelection sel = (StructuredSelection)this.editor.getSelectionCache().getLastRawSelection();
            Object obj = sel.getFirstElement();
            if (obj instanceof EditPart) {
                obj = ((EditPart)obj).getModel();
            }
            if (obj instanceof ANode) {
                current = this.getParentBand((ANode)obj);
            }
        }
        if (current != null) {
            return new CreateBandDetailCommand(current, new MBand());
        }
        return null;
    }

    private MBand getParentBand(ANode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof MBand && ((MBand)node).getBandType() == BandTypeEnum.DETAIL) {
            return (MBand)node;
        }
        return this.getParentBand(node.getParent());
    }

    @Override
    public void run() {
        this.fresh = false;
        super.run();
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateDetailBandAction_actionName);
        this.setToolTipText(Messages.CreateDetailBandAction_actionTooltip);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }
}

