/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import com.jaspersoft.studio.model.group.command.DeleteGroupCommand;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DeleteGroupReportAction
extends DeleteAction {
    public static final String ID = "delete_group_report";

    public DeleteGroupReportAction(IEditorPart editor) {
        super(editor.getSite().getPart());
    }

    protected void init() {
        super.init();
        this.setText(Messages.DeleteGroupReportAction_delete_group);
        this.setToolTipText(Messages.DeleteGroupReportAction_delete_group_tool_tip);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setEnabled(false);
    }

    public Command createDeleteCommand(List objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        deleteReq.setEditParts(objects);
        JSSCompoundCommand compoundCmd = new JSSCompoundCommand("Delete Report Group", null);
        int i = 0;
        while (i < objects.size()) {
            ANode node;
            EditPart part = (EditPart)objects.get(i);
            DeleteGroupCommand cmd = null;
            if ((part instanceof TreeEditPart || part instanceof BandEditPart) && (node = (ANode)part.getModel()).getParent() != null) {
                compoundCmd.setReferenceNodeIfNull(node);
                if (node instanceof MBandGroupHeader) {
                    cmd = new DeleteGroupCommand((MReport)node.getParent(), (MBandGroupHeader)node);
                }
                if (node instanceof MBandGroupFooter) {
                    cmd = new DeleteGroupCommand((MReport)node.getParent(), (MBandGroupFooter)node);
                }
            }
            if (cmd != null) {
                compoundCmd.add(cmd);
            }
            ++i;
        }
        return compoundCmd;
    }
}

