/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.editor.outline.actions.AbstractFilePropertyAction;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class HideDefaultVariablesAction
extends AbstractFilePropertyAction {
    public static final String ID = "hide_default_variables";
    private static final String HIDE_PROPERTY_NAME = "com.jaspersoft.studio.hideVariables";

    public HideDefaultVariablesAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText("Hide Default Variables");
        this.setToolTipText("Hide the defualt variables");
        this.setId(ID);
        this.setEnabled(false);
    }

    public static boolean areDefaultVariablesHidden(JasperReportsConfiguration jConfig) {
        return HideDefaultVariablesAction.isPropertySet(jConfig, HIDE_PROPERTY_NAME);
    }

    @Override
    protected String getPersistentPropertyName() {
        return HIDE_PROPERTY_NAME;
    }

    @Override
    protected Command createCommand() {
        List<Object> selection = this.editor.getSelectionCache().getSelectionModelForType(MVariables.class);
        if (selection.size() == 1) {
            MVariables selectedVariables = (MVariables)selection.get(0);
            return this.generateCommand(selectedVariables);
        }
        return null;
    }

    public boolean isChecked() {
        List<Object> selection = this.editor.getSelectionCache().getSelectionModelForType(MVariables.class);
        if (selection.size() == 1) {
            MVariables selectedVariables = (MVariables)selection.get(0);
            return HideDefaultVariablesAction.isPropertySet(selectedVariables.getJasperConfiguration(), this.getPersistentPropertyName());
        }
        return false;
    }
}

