/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.jasper.LazyImageConverter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.ui.IWorkbenchPart;

public class RefreshImageAction
extends ACachedSelectionAction {
    public static final String ID = "refresh_image_action";

    public RefreshImageAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.RefreshImageAction_actionName);
        this.setToolTipText(Messages.RefreshImageAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/refresh_image_action.png"));
        this.setEnabled(false);
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.getSelectedImages().isEmpty();
    }

    @Override
    public void run() {
        List<MImage> images = this.getSelectedImages();
        JasperDesign jd = null;
        for (MImage image : images) {
            JasperReportsConfiguration jConfig = image.getJasperConfiguration();
            LazyImageConverter.getInstance().removeCachedImage(jConfig, image);
            if (jd != null) continue;
            jd = image.getJasperDesign();
        }
        for (JRDesignElement element : ModelUtils.getAllElements(jd)) {
            element.getEventSupport().firePropertyChange(MGraphicElement.FORCE_GRAPHICAL_REFRESH, false, true);
        }
    }

    private List<MImage> getSelectedImages() {
        List<Object> templates = this.editor.getSelectionCache().getSelectionModelForType(MImage.class);
        ArrayList<MImage> result = new ArrayList<MImage>();
        for (Object template : templates) {
            result.add((MImage)template);
        }
        return result;
    }
}

