/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.style.wizard.StyleTemplateExportWizard;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.style.command.CreateStyleTemplateCommand;
import com.jaspersoft.studio.model.style.command.SimpleDeleteStyleCommand;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class SaveStyleAsTemplateAction
extends ACachedSelectionAction {
    public static final String ID = "export_style_as_template";

    public SaveStyleAsTemplateAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        this.setText(Messages.ExportStyleAsTemplateAction_actionName);
        this.setToolTipText(Messages.ExportStyleAsTemplateAction_actionTooltip);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/export_style.png"));
        this.setEnabled(false);
        this.setLazyEnablementCalculation(true);
    }

    @Override
    protected boolean calculateEnabled() {
        List<Object> elements = this.editor.getSelectionCache().getSelectionModelForType(MStyle.class);
        if (elements.size() == this.getSelectedObjects().size()) {
            for (Object rawStyle : elements) {
                MStyle style = (MStyle)rawStyle;
                if (style.isEditable() && !(style instanceof MConditionalStyle)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        Pair<List<MStyle>, List<JRStyle>> styles = this.getSelectedStyles();
        StyleTemplateExportWizard importWizard = new StyleTemplateExportWizard((List)styles.getValue());
        ISelection selection = this.getSelection();
        StructuredSelection structured = null;
        structured = selection instanceof StructuredSelection ? (StructuredSelection)selection : new StructuredSelection();
        importWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)structured);
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)importWizard);
        if (dialog.open() == 0) {
            if (MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)Messages.SaveStyleAsTemplateAction_replaceTitle, (String)Messages.SaveStyleAsTemplateAction_replaceMessage)) {
                JSSCompoundCommand cmd = new JSSCompoundCommand(Messages.SaveStyleAsTemplateAction_replaceTitle, (ANode)((List)styles.getKey()).get(0));
                JasperReportsConfiguration jconfig = ((MStyle)((List)styles.getKey()).get(0)).getJasperConfiguration();
                ANode root = this.getRoot((ANode)((List)styles.getKey()).get(0));
                Map<String, List<ANode>> usedStyles = root.getUsedStyles();
                for (MStyle style : (List)styles.getKey()) {
                    Command deleteCommand = this.getDeleteCommand(style);
                    if (deleteCommand == null) continue;
                    cmd.add(deleteCommand);
                    String styleName = style.getValue().getName();
                    List<ANode> elementsUsingStyle = usedStyles.get(styleName);
                    if (elementsUsingStyle == null) continue;
                    for (ANode element : elementsUsingStyle) {
                        SetValueCommand setStyleCommand = new SetValueCommand();
                        setStyleCommand.setTarget((IPropertySource)element);
                        setStyleCommand.setPropertyValue(styleName);
                        setStyleCommand.setPropertyId("parentStyle");
                        cmd.add(setStyleCommand);
                    }
                }
                IFile templateFile = importWizard.getReportFile();
                Command createCommand = this.getCreateCommand(templateFile, ((MStyle)((List)styles.getKey()).get(0)).getParent());
                if (createCommand != null) {
                    cmd.add(createCommand);
                }
                this.execute((Command)cmd);
                if (jconfig != null) {
                    jconfig.refreshCachedStyles();
                }
            } else {
                importWizard.openStyleEditor();
            }
        }
    }

    private ANode getRoot(ANode currentNode) {
        if (currentNode instanceof MPage) {
            return this.getRoot(((MPage)currentNode).getRealParent());
        }
        if (currentNode instanceof MRoot) {
            return currentNode;
        }
        return this.getRoot(currentNode.getParent());
    }

    protected Command getCreateCommand(IFile templateFile, ANode parent) {
        JRDesignReportTemplate jrTemplate = MStyleTemplate.createJRTemplate();
        jrTemplate.setSourceExpression((JRExpression)this.getFileExpression(templateFile, parent.getJasperConfiguration().getAssociatedReportFile()));
        MStyleTemplate templateModel = new MStyleTemplate(null, (JRReportTemplate)jrTemplate, -1);
        return new CreateStyleTemplateCommand((MStyles)parent, templateModel, 0);
    }

    protected JRDesignExpression getFileExpression(IFile file, IFile contextFile) {
        String filepath = null;
        filepath = contextFile != null && file.getProject().equals((Object)contextFile.getProject()) ? file.getProjectRelativePath().toPortableString().replaceAll(String.valueOf(file.getProject().getName()) + "/", "") : file.getRawLocationURI().toASCIIString();
        String fileExpressionText = StringUtils.replaceBackslashWithDoubleBackslash((String)filepath.replace(System.getProperty("file.separator").charAt(0), '/'));
        JRDesignExpression jrFileExpression = new JRDesignExpression();
        jrFileExpression.setText("\"" + fileExpressionText + "\"");
        return jrFileExpression;
    }

    protected Command getDeleteCommand(MStyle style) {
        return new SimpleDeleteStyleCommand((MStyles)style.getParent(), (JRDesignStyle)style.getValue());
    }

    private Pair<List<MStyle>, List<JRStyle>> getSelectedStyles() {
        List objects = this.getSelectedObjects();
        if (objects == null || objects.isEmpty()) {
            return new Pair(new ArrayList(), new ArrayList());
        }
        ArrayList<JRStyle> styles = new ArrayList<JRStyle>();
        ArrayList<MStyle> modelStyles = new ArrayList<MStyle>();
        for (Object obj : objects) {
            ANode n;
            if (!(obj instanceof EditPart) || !((n = (ANode)((EditPart)obj).getModel()) instanceof MStyle) || styles.contains(n.getValue())) continue;
            styles.add((JRStyle)n.getValue());
            modelStyles.add((MStyle)n);
        }
        return new Pair(modelStyles, styles);
    }
}

