/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions.field;

import com.jaspersoft.studio.editor.outline.actions.ACreateAndSelectAction;
import com.jaspersoft.studio.editor.outline.actions.field.ShowFieldsTreeAction;
import com.jaspersoft.studio.editor.palette.JDPaletteCreationFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFieldsContainer;
import com.jaspersoft.studio.model.field.command.CreateFieldsContainerCommand;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateFieldsContainerAction
extends ACreateAndSelectAction {
    public static final String ID = "create_fieldscontainer";

    public CreateFieldsContainerAction(IWorkbenchPart part) {
        super(part);
        this.setCreationFactory(new JDPaletteCreationFactory(MFieldsContainer.class));
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.checkAllSelectedObjects(MField.class, MFieldsContainer.class) && ShowFieldsTreeAction.isFieldsTree(this.getJrConfig())) {
            return super.calculateEnabled();
        }
        return false;
    }

    @Override
    public Command createCommand() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        if (objects.size() > 1) {
            ArrayList<ANode> nodes = new ArrayList<ANode>();
            for (Object obj : objects) {
                if (!(obj instanceof EditPart)) continue;
                nodes.add((ANode)((EditPart)obj).getModel());
            }
            return new CreateFieldsContainerCommand(nodes);
        }
        return super.createCommand();
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateFieldsContainerAction_0);
        this.setToolTipText(Messages.CreateFieldsContainerAction_1);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }
}

