/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.DeltaVisitor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;

public abstract class ABasicEditor
extends EditorPart {
    protected boolean listenResource;
    protected JasperReportsConfiguration jrContext;
    private IPartListener partListener;
    private ResourceTracker resourceListener;
    protected boolean isDirty = false;

    public ABasicEditor(boolean listenResource) {
        this.listenResource = listenResource;
        if (listenResource) {
            this.partListener = new ResourcePartListener();
            this.resourceListener = new ResourceTracker();
        }
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        }
        this.partListener = null;
        if (this.resourceListener != null) {
            ((IFileEditorInput)this.getEditorInput()).getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        this.disposeContext();
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        IFile file;
        if (this.resourceListener != null && this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.resourceListener != null && this.getEditorInput() != null) {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                file = ((IFileEditorInput)this.getEditorInput()).getFile();
                file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 7);
                this.setPartName(file.getName());
            } else {
                boolean cfr_ignored_0 = this.getEditorInput() instanceof FileStoreEditorInput;
            }
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        if (this.partListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IFile file = null;
        if (input instanceof FileStoreEditorInput) {
            input = FileUtils.checkAndConvertEditorInput((IEditorInput)input, (IProgressMonitor)new NullProgressMonitor());
            this.init(site, input);
            return;
        }
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        try {
            this.initJRContext(file);
            JaspersoftStudioPlugin.getExtensionManager().onInitContext(this.jrContext);
            this.setSite((IWorkbenchPartSite)site);
            this.setPartName(input.getName());
            this.setInput(input);
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
    }

    public JasperReportsConfiguration getJrContext() {
        return this.jrContext;
    }

    protected void initJRContext(IFile file) throws CoreException, JavaModelException {
        if (this.jrContext == null) {
            this.jrContext = JasperReportsConfiguration.getDefaultJRConfig(file);
        }
    }

    protected void disposeContext() {
        if (this.jrContext != null) {
            this.jrContext.dispose();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == JasperReportsContext.class) {
            return this.jrContext;
        }
        return super.getAdapter(adapter);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        this.isDirty = false;
    }

    public void doSave(IProgressMonitor monitor) {
        this.isDirty = false;
    }

    protected void handleValueChanged() {
        this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> {
            this.isDirty = true;
            this.firePropertyChange(257);
        });
    }

    class ResourcePartListener
    implements IPartListener {
        ResourcePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part != ABasicEditor.this) {
                return;
            }
            if (!((IFileEditorInput)ABasicEditor.this.getEditorInput()).getFile().exists()) {
                ABasicEditor.this.getSite().getPage().closeEditor((IEditorPart)ABasicEditor.this, false);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            IFile file = ((IFileEditorInput)ABasicEditor.this.getEditorInput()).getFile();
            if (!file.exists()) {
                try {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class ResourceTracker
    implements IResourceChangeListener {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 4: {
                    break;
                }
                case 1: {
                    try {
                        DeltaVisitor visitor = new DeltaVisitor(ABasicEditor.this);
                        event.getDelta().accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        UIUtils.showError((Throwable)e);
                    }
                    break;
                }
            }
        }
    }
}

