/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview;

import com.jaspersoft.studio.editor.DeltaVisitor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class ABasicMultiPartEditor
extends MultiPageEditorPart {
    protected boolean listenResource;
    protected JasperReportsConfiguration jrContext;
    private IPartListener partListener;
    private ResourceTracker resourceListener;
    boolean closing = false;

    public ABasicMultiPartEditor(boolean listenResource) {
        this.listenResource = listenResource;
        if (listenResource) {
            this.partListener = new ResourcePartListener();
            this.resourceListener = new ResourceTracker();
        }
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        }
        this.partListener = null;
        if (this.resourceListener != null) {
            ((IFileEditorInput)this.getEditorInput()).getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        this.disposeContext();
        super.dispose();
    }

    protected void disposeContext() {
        if (this.jrContext != null) {
            this.jrContext.dispose();
        }
    }

    protected void initJRContext(IFile file) throws CoreException, JavaModelException {
        if (this.jrContext == null) {
            this.jrContext = JasperReportsConfiguration.getDefaultJRConfig(file);
        }
    }

    protected void setInput(IEditorInput input) {
        IFile file;
        if (this.resourceListener != null && this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.resourceListener != null && this.getEditorInput() != null) {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                file = ((IFileEditorInput)this.getEditorInput()).getFile();
                file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 7);
                this.setPartName(file.getName());
            } else {
                boolean cfr_ignored_0 = this.getEditorInput() instanceof FileStoreEditorInput;
            }
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        if (this.partListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IFile file = null;
        if (input instanceof FileStoreEditorInput) {
            input = FileUtils.checkAndConvertEditorInput((IEditorInput)input, (IProgressMonitor)new NullProgressMonitor());
            this.init(site, input);
            return;
        }
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        try {
            this.initJRContext(file);
            this.setSite((IWorkbenchPartSite)site);
            this.setPartName(input.getName());
            this.setInput(input);
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == JasperReportsContext.class) {
            return this.jrContext;
        }
        return super.getAdapter(adapter);
    }

    protected void closeEditor() {
        IWorkbenchPage apage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (apage = activeWorkbenchWindow.getActivePage()) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ABasicMultiPartEditor.this.closing = true;
                    apage.closeEditor((IEditorPart)ABasicMultiPartEditor.this, false);
                }
            });
        }
    }

    class ResourcePartListener
    implements IPartListener {
        ResourcePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part != ABasicMultiPartEditor.this) {
                return;
            }
            if (!((IFileEditorInput)ABasicMultiPartEditor.this.getEditorInput()).getFile().exists()) {
                ABasicMultiPartEditor.this.getSite().getPage().closeEditor((IEditorPart)ABasicMultiPartEditor.this, false);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            IFile file = ((IFileEditorInput)ABasicMultiPartEditor.this.getEditorInput()).getFile();
            if (!file.exists()) {
                try {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class ResourceTracker
    implements IResourceChangeListener {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage[] pages = ABasicMultiPartEditor.this.getSite().getWorkbenchWindow().getPages();
                            int i = 0;
                            while (i < pages.length) {
                                ++i;
                            }
                        }
                    });
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    try {
                        DeltaVisitor visitor = new DeltaVisitor((EditorPart)ABasicMultiPartEditor.this);
                        event.getDelta().accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        UIUtils.showError((Throwable)e);
                    }
                    break;
                }
            }
        }
    }
}

