/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview;

import com.jaspersoft.studio.editor.action.PrintAction;
import com.jaspersoft.studio.editor.preview.ABasicEditor;
import com.jaspersoft.studio.editor.preview.MultiPageContainer;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.toolbar.ATopToolBarManager;
import com.jaspersoft.studio.editor.preview.toolbar.TopToolBarManagerJRPrint;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.AViewsFactory;
import com.jaspersoft.studio.editor.preview.view.ViewsFactory;
import com.jaspersoft.studio.editor.preview.view.control.VSimpleErrorPreview;
import com.jaspersoft.studio.editor.preview.view.report.IJRPrintable;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.Console;
import java.io.InputStream;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PreviewJRPrint
extends ABasicEditor {
    private boolean hideParameters = true;
    private JasperPrint jasperPrint;
    private ActionRegistry actionRegistry;
    protected String currentViewer;
    protected MultiPageContainer rightContainer;
    protected TopToolBarManagerJRPrint actionToolBarManager;
    protected ATopToolBarManager dataDapterToolBarManager;
    protected VSimpleErrorPreview errorPreview;
    protected AViewsFactory viewFactory;
    private boolean notRunning = true;
    private Console console;
    protected Composite rightComposite;

    public void setHideParameters(boolean hideParameters) {
        this.hideParameters = hideParameters;
    }

    public boolean isHideParameters() {
        return this.hideParameters;
    }

    public PreviewJRPrint() {
        super(true);
    }

    public PreviewJRPrint(boolean listenresource) {
        super(listenresource);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == JasperPrint.class) {
            return this.getJasperPrint();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.loadJRPrint(this.getEditorInput());
        ActionRegistry registry = this.getActionRegistry();
        PrintAction action = new PrintAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)action);
    }

    protected void loadJRPrint(IEditorInput input) throws PartInitException {
        InputStream in = null;
        try {
            IFile file = null;
            if (!(input instanceof IFileEditorInput)) {
                throw new PartInitException("Invalid Input: Must be IFileEditorInput or FileStoreEditorInput");
            }
            file = ((IFileEditorInput)input).getFile();
            in = file.getContents();
            Statistics stats = new Statistics();
            if (file.getFileExtension().equalsIgnoreCase("jrpxml")) {
                this.setJasperPrint(stats, JRPrintXmlLoader.load((JasperReportsContext)this.jrContext, (InputStream)in));
            } else {
                Object obj = JRLoader.loadObject((JasperReportsContext)this.jrContext, (InputStream)in);
                if (obj instanceof JasperPrint) {
                    this.setJasperPrint(stats, (JasperPrint)obj);
                }
            }
        }
        catch (Exception e) {
            throw new PartInitException(Messages.PreviewJRPrint_1, (Throwable)e);
        }
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public void setJasperPrint(Statistics stats, JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
        UIUtils.getDisplay().asyncExec(() -> {
            if (this.getDefaultViewer() instanceof IJRPrintable) {
                JasperPrint jrprint = this.getJasperPrint();
                if (jrprint != null) {
                    this.getRightContainer().switchView(stats, this.getDefaultViewerKey());
                } else {
                    this.getRightContainer().switchView(stats, this.errorPreview);
                }
            }
        });
    }

    public String getCurrentViewer() {
        return this.currentViewer;
    }

    public void setCurrentViewer(String viewerKey, boolean refresh) {
        if (this.getViewFactory().getKeys().contains(viewerKey)) {
            this.currentViewer = viewerKey;
            if (refresh) {
                this.rightContainer.switchView(this.currentViewer);
            }
        }
    }

    public String getDefaultViewerKey() {
        if (this.currentViewer == null) {
            this.currentViewer = "Java";
        }
        return this.currentViewer;
    }

    public APreview getDefaultViewer() {
        return this.getRightContainer().getViewer(this.getDefaultViewerKey());
    }

    protected void afterRightSwitchView() {
    }

    public MultiPageContainer getRightContainer() {
        if (this.rightContainer == null) {
            this.rightContainer = new MultiPageContainer(){
                private boolean same = false;

                @Override
                public void afterSwitchView() {
                    PreviewJRPrint.this.afterRightSwitchView();
                }

                @Override
                public void switchView(Statistics stats, String key) {
                    JasperPrint jp;
                    this.same = PreviewJRPrint.this.currentViewer == key;
                    PreviewJRPrint.this.currentViewer = key;
                    APreview view = (APreview)this.pmap.get(key);
                    if (view instanceof IJRPrintable && (jp = ((IJRPrintable)((Object)view)).getJrPrint()) == null) {
                        this.same = false;
                    }
                    super.switchView(stats, key);
                }

                @Override
                public void switchView(String key) {
                    this.same = PreviewJRPrint.this.currentViewer == key;
                    PreviewJRPrint.this.currentViewer = key;
                    super.switchView(key);
                }

                @Override
                public void switchView(Statistics stats, APreview view) {
                    if (!this.same && !PreviewJRPrint.this.switchRightView(view, stats, this)) {
                        return;
                    }
                    super.switchView(stats, view);
                    if (!this.same || !view.isContributed2ToolBar()) {
                        Display.getDefault().syncExec(() -> {
                            if (PreviewJRPrint.this.actionToolBarManager != null) {
                                PreviewJRPrint.this.actionToolBarManager.contributeItems(view);
                            }
                        });
                    } else {
                        PreviewJRPrint.this.actionToolBarManager.refreshToolbar();
                    }
                }

                @Override
                public void dispose() {
                    super.dispose();
                    PreviewJRPrint.this.actionToolBarManager.removeAll();
                }
            };
        }
        return this.rightContainer;
    }

    public boolean switchRightView(APreview view, Statistics stats, MultiPageContainer container) {
        if (view instanceof IJRPrintable) {
            try {
                ((IJRPrintable)((Object)view)).setJRPRint(stats, this.jasperPrint);
                if (this.console != null) {
                    this.console.setStatistics(stats);
                }
            }
            catch (Exception e) {
                this.errorPreview.setMessage(Messages.PreviewJRPrint_2);
                container.switchView(stats, this.errorPreview);
                this.getConsole().addError(e, null);
                return false;
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getRightContainer().dispose();
    }

    protected TopToolBarManagerJRPrint getActionToolBarManager(Composite container) {
        if (this.actionToolBarManager == null) {
            this.actionToolBarManager = new TopToolBarManagerJRPrint(this, container);
        }
        return this.actionToolBarManager;
    }

    protected ATopToolBarManager getDataAdapterToolBarManager(Composite container) {
        if (this.dataDapterToolBarManager == null) {
            this.dataDapterToolBarManager = new ATopToolBarManager(this, container){

                @Override
                protected void fillToolbar(IToolBarManager tbManager) {
                }
            };
        }
        return this.dataDapterToolBarManager;
    }

    public VSimpleErrorPreview getErrorView() {
        return this.errorPreview;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.jaspersoft.studio.doc.editor_jrprint");
        this.getDataAdapterToolBarManager(container);
        this.getActionToolBarManager(container);
        Composite rcmp = this.createRight(container);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        rcmp.setLayoutData((Object)gd);
    }

    protected Composite createRight(Composite parent) {
        this.rightComposite = new Composite(parent, 2048);
        StackLayout stacklayoutView = new StackLayout();
        this.rightComposite.setLayout((Layout)stacklayoutView);
        this.getRightContainer().populate(this.rightComposite, this.getViewFactory().createPreviews(this.rightComposite, this.jrContext));
        this.errorPreview = new VSimpleErrorPreview(this.rightComposite, this.jrContext);
        return this.rightComposite;
    }

    public AViewsFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new ViewsFactory();
        }
        return this.viewFactory;
    }

    public void setFocus() {
        if (this.dataDapterToolBarManager != null) {
            this.dataDapterToolBarManager.setFocus();
        }
    }

    public void setNotRunning(boolean norun) {
        this.notRunning = norun;
        if (this.dataDapterToolBarManager != null) {
            this.dataDapterToolBarManager.refreshToolbar();
            if (norun) {
                this.dataDapterToolBarManager.setEnabled(true);
            }
        }
        if (this.actionToolBarManager != null) {
            this.actionToolBarManager.refreshToolbar();
            if (norun) {
                this.actionToolBarManager.setEnabled(true);
            }
        }
    }

    public boolean isNotRunning() {
        return this.notRunning;
    }

    public Console getConsole() {
        if (this.console == null) {
            this.console = Console.showConsole(this.getEditorInput().getName(), this.jrContext);
        }
        return this.console;
    }
}

