/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.actions;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.context.AEditorContext;
import com.jaspersoft.studio.editor.preview.IRunReport;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.view.control.IReportRunner;
import com.jaspersoft.studio.editor.preview.view.control.ReportController;
import com.jaspersoft.studio.messages.Messages;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class RunStopAction
extends Action {
    public static final String MODERUN_LOCAL = "RUNLOCAL";
    public static final String ID = "PREVIEWRELOADACTION";
    private PreviewJRPrint editor;
    private Menu listMenu;

    public RunStopAction(PreviewJRPrint editor) {
        this.editor = editor;
        this.setId(ID);
        this.setDescription(Messages.RunStopAction_runreport_desc);
        this.setToolTipText(Messages.RunStopAction_runreport_desc);
        ImageDescriptor imgd = JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/start_task.gif");
        this.setImageDescriptor(imgd);
        this.setDisabledImageDescriptor(imgd);
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.editor.isNotRunning();
    }

    public void run() {
        if (this.editor instanceof IRunReport) {
            ((IRunReport)((Object)this.editor)).runReport();
        }
    }

    public void dispose() {
        if (this.listMenu != null) {
            this.listMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.listMenu != null) {
            this.listMenu.dispose();
        }
        this.listMenu = new Menu(parent);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.getSource();
                menuItem.setSelection(true);
                if (RunStopAction.this.editor instanceof IRunReport) {
                    ((IRunReport)((Object)RunStopAction.this.editor)).setMode((String)menuItem.getData("run.key"));
                }
                RunStopAction.this.run();
            }
        };
        AEditorContext cntx = this.editor.getJrContext().getEditorContext();
        String defMode = cntx.getDefaultRunMode();
        if (cntx.isAllowOtherRunners()) {
            MenuItem m1 = new MenuItem(this.listMenu, 8);
            m1.setText("Run Report");
            m1.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/start_task.gif"));
            m1.addSelectionListener((SelectionListener)listener);
            m1.setData("run.key", (Object)MODERUN_LOCAL);
            this.setupMenu(m1, defMode);
        }
        for (Map.Entry<String, IReportRunner> entry : ReportController.getRunners().entrySet()) {
            if (!entry.getKey().equals(defMode)) continue;
            MenuItem m1 = new MenuItem(this.listMenu, 16);
            m1.setText(entry.getValue().getLabel());
            m1.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/start_task.gif"));
            m1.addSelectionListener((SelectionListener)listener);
            m1.setData("run.key", (Object)entry.getKey());
            this.setupMenu(m1, defMode);
        }
        if (this.listMenu.getItemCount() == 1) {
            this.listMenu.getItems()[0].dispose();
        }
        return this.listMenu;
    }

    private void setupMenu(MenuItem menuItem, String mode) {
        String key = (String)menuItem.getData("run.key");
        if (mode.equals(key)) {
            menuItem.setSelection(true);
            if (this.editor instanceof IRunReport) {
                ((IRunReport)((Object)this.editor)).setMode(mode);
            }
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

