/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.actions.export;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.preview.actions.export.AReportViewerAction;
import com.jaspersoft.studio.editor.preview.actions.export.ExportMenuAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.pages.Pages;
import com.jaspersoft.studio.preferences.exporter.JRExporterPreferencePage;
import com.jaspersoft.studio.utils.Callback;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleReportExportConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.FileDialog;

public abstract class AExportAction
extends AReportViewerAction {
    private String[] filterNames;
    private String[] fileExtensions;
    private String defaultFileExtension;
    private String fileName;
    private String filterPath;
    private JasperReportsConfiguration jContext;
    private ExportMenuAction parentMenu;
    public static final String EXPPARAM_INDEX_PAGE = "expparam.index.page";
    public static final String EXPPARAM_OFFSET_Y = "expparam.offset.y";
    public static final String EXPPARAM_OFFSET_X = "expparam.offset.x";

    public AExportAction(IReportViewer viewer, JasperReportsConfiguration jContext, ExportMenuAction parentMenu) {
        super(viewer);
        this.jContext = jContext;
        this.parentMenu = parentMenu;
    }

    public void setDefaultFileExtension(String defaultFileExtension) {
        this.defaultFileExtension = defaultFileExtension;
    }

    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    protected void setFileExtensions() {
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    private static String getFileExtension(String fileName) {
        int ind;
        if (fileName != null && (ind = fileName.lastIndexOf(46)) != -1) {
            return fileName.substring(ind + 1);
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    @Override
    public void run() {
        FileDialog dialog = new FileDialog(UIUtils.getShell(), 8196);
        this.setFileExtensions();
        if (this.filterNames != null) {
            dialog.setFilterNames(this.filterNames);
        }
        if (this.fileExtensions != null) {
            dialog.setFilterExtensions(this.fileExtensions);
        }
        if (this.filterPath != null) {
            dialog.setFilterPath(this.filterPath);
        }
        if (this.fileName != null) {
            dialog.setFileName(this.fileName);
        } else if (this.getReportViewer() != null && this.getReportViewer().getReport() != null) {
            String exportFilename = this.getReportViewer().getReport().getProperty("com.jaspersoft.studio.exporter.filename");
            if (exportFilename != null) {
                dialog.setFileName(exportFilename);
            } else {
                dialog.setFileName(Misc.nvl((String)this.getReportViewer().getReport().getName()));
            }
        }
        String filePath = dialog.open();
        if (filePath != null) {
            String extension;
            if (this.defaultFileExtension != null && this.fileExtensions != null && (extension = AExportAction.getFileExtension(filePath)) != null) {
                String[] stringArray = this.fileExtensions;
                int n = this.fileExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String fe = stringArray[n2];
                    if (fe.endsWith(extension)) {
                        if (filePath.toLowerCase().endsWith(this.defaultFileExtension.toLowerCase())) break;
                        filePath = String.valueOf(filePath) + '.' + this.defaultFileExtension;
                        break;
                    }
                    ++n2;
                }
            }
            try {
                this.export(new File(filePath), new Callback<File>(){

                    @Override
                    public void completed(File value) {
                        String reportLanguage;
                        JaspersoftStudioPlugin.getInstance().getUsageManager().audit(((Object)((Object)AExportAction.this)).getClass().getName(), "ExportFormat");
                        if (AExportAction.this.jContext != null && AExportAction.this.jContext.getJasperDesign() != null && (reportLanguage = AExportAction.this.jContext.getJasperDesign().getLanguage()) != null) {
                            JaspersoftStudioPlugin.getInstance().getUsageManager().audit(reportLanguage, "Language");
                        }
                    }
                });
            }
            catch (Throwable e) {
                UIUtils.showError((Throwable)e);
            }
        }
        if (this.parentMenu != null) {
            this.parentMenu.setDefaultAction((IAction)this);
        }
    }

    protected void export(final File file, final Callback<File> callback) throws Exception {
        final JasperPrint jrPrint = this.getReportViewer().getReport();
        if (jrPrint == null || jrPrint.getPages() == null) {
            return;
        }
        Job job = new Job(Messages.AExportAction_exportreport){

            protected IStatus run(IProgressMonitor monitor) {
                AExportAction.this.doExport(file, jrPrint, monitor);
                UIUtils.getDisplay().syncExec(() -> callback.completed(file));
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }

    public void preview(final File file, final JasperPrint jrPrint, final Callback<File> callback) throws Exception {
        if (jrPrint == null || jrPrint.getPages() == null) {
            return;
        }
        Job job = new Job(Messages.AExportAction_exportreport){

            protected IStatus run(IProgressMonitor monitor) {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(AExportAction.this.jContext.getClassLoader());
                    AExportAction.this.doPreview(file, jrPrint, monitor);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
                UIUtils.getDisplay().syncExec(() -> callback.completed(file));
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }

    public void preview(File file, Callback<File> callback) throws Exception {
        this.preview(file, this.getReportViewer().getReport(), callback);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getReportViewer().hasReport();
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws Throwable {
        JRAbstractExporter<?, ?, ?, ?> exporter = this.getExporter(this.jContext, monitor, file);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.getReportViewer().getReport()));
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Object contextCL = this.jContext.getValue("CURRENT_CLASS_LOADER");
                if (contextCL instanceof ClassLoader) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)contextCL);
                }
                exporter.exportReport();
            }
            catch (Throwable e) {
                UIUtils.showError((Throwable)e);
                JaspersoftStudioPlugin.getInstance().logError(Messages.AExportAction_ExportErrorMsg, e);
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    protected void setupReportConfiguration(SimpleReportExportConfiguration conf, JRExportProgressMonitor monitor) {
        conf.setProgressMonitor(monitor);
        String indPage = this.jContext.getProperty(EXPPARAM_INDEX_PAGE);
        if (!Misc.isNullOrEmpty((String)indPage)) {
            Pages p = new Pages().parseString(indPage);
            if (p.getPage() != null) {
                conf.setPageIndex(p.getPage());
            } else if (p.getFrom() != null) {
                conf.setStartPageIndex(p.getFrom());
                conf.setEndPageIndex(p.getTo());
            }
        }
        conf.setOffsetX(this.jContext.getPropertyInteger(EXPPARAM_OFFSET_X));
        conf.setOffsetY(this.jContext.getPropertyInteger(EXPPARAM_OFFSET_Y));
    }

    protected abstract JRAbstractExporter<?, ?, ?, ?> getExporter(JasperReportsConfiguration var1, JRExportProgressMonitor var2, File var3);

    protected boolean continueIfFileExist() {
        boolean result = true;
        String exporterValueString = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("exporterOverwrite");
        JRExporterPreferencePage.OVERWRITE_STATE exporterValue = JRExporterPreferencePage.OVERWRITE_STATE.ASK_EVERYTIME;
        if (exporterValueString != null && !exporterValueString.isEmpty()) {
            exporterValue = JRExporterPreferencePage.OVERWRITE_STATE.valueOf(exporterValueString);
        }
        if (exporterValue.equals((Object)JRExporterPreferencePage.OVERWRITE_STATE.ASK_EVERYTIME)) {
            Boolean[] answers = UIUtils.showConfirmation((String)Messages.AExportAction_overwriteTitle, (String)Messages.AExportAction_overwriteMessage, (String)Messages.AExportAction_overwriteCheckbox);
            result = answers[0];
            if (answers[1].booleanValue()) {
                String selectionToRemember = result ? JRExporterPreferencePage.OVERWRITE_STATE.OVERWRITE_TARGET.toString() : JRExporterPreferencePage.OVERWRITE_STATE.STOP_OPERATION.toString();
                JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("exporterOverwrite", selectionToRemember);
            }
        } else if (exporterValue.equals((Object)JRExporterPreferencePage.OVERWRITE_STATE.STOP_OPERATION)) {
            result = false;
        }
        return result;
    }

    protected void doExport(File file, JasperPrint jrPrint, final IProgressMonitor monitor) {
        try {
            try {
                if (jrPrint != null && jrPrint.getPages() != null) {
                    final Integer size = jrPrint.getPages().size();
                    monitor.beginTask(Messages.AExportAction_exportreport, size.intValue());
                    boolean continueOperation = true;
                    if (file.exists()) {
                        continueOperation = this.continueIfFileExist();
                    }
                    if (continueOperation) {
                        this.exportWithProgress(file, new JRExportProgressMonitor(){
                            private int current = 0;

                            public void afterPageExport() {
                                if (monitor.isCanceled()) {
                                    Thread.currentThread().interrupt();
                                }
                                monitor.worked(1);
                                monitor.subTask(MessageFormat.format(Messages.PageNumberContributionItem_page, this.current++, size));
                            }
                        });
                    }
                }
            }
            catch (Throwable e) {
                UIUtils.showError((Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void doPreview(File file, JasperPrint jrPrint, final IProgressMonitor monitor) {
        try {
            try {
                if (jrPrint != null && jrPrint.getPages() != null) {
                    final Integer size = jrPrint.getPages().size();
                    monitor.beginTask(Messages.AExportAction_exportreport, size.intValue());
                    this.exportWithProgress(file, new JRExportProgressMonitor(){
                        private int current = 0;

                        public void afterPageExport() {
                            if (monitor.isCanceled()) {
                                Thread.currentThread().interrupt();
                            }
                            monitor.worked(1);
                            monitor.subTask(MessageFormat.format(Messages.PageNumberContributionItem_page, this.current++, size));
                            AExportAction.this.auditPreview();
                        }
                    });
                }
            }
            catch (Throwable e) {
                UIUtils.showError((Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void auditPreview() {
        String reportLanguage;
        JaspersoftStudioPlugin.getInstance().getUsageManager().audit(this.getText(), "PreviewFormat");
        if (this.jContext != null && this.jContext.getJasperDesign() != null && (reportLanguage = this.jContext.getJasperDesign().getLanguage()) != null) {
            JaspersoftStudioPlugin.getInstance().getUsageManager().audit(reportLanguage, "Language");
        }
    }
}

