/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.datasnapshot;

import com.jaspersoft.studio.editor.preview.datasnapshot.JSSColumnDataCacheHandler;
import com.jaspersoft.studio.editor.preview.datasnapshot.JssDataSnapshot;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.data.cache.PopulatedSnapshotCacheHandler;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.SimpleReportContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DataSnapshotManager {
    public static final String SAVE_SNAPSHOT = "net.sf.jasperreports.datasnapshot.SAVESNAPSHOT";

    public static void setCaching(Map<String, Object> parameters, boolean on) {
        if (on) {
            DataSnapshotManager.setDataSnapshot(parameters, on);
        } else {
            parameters.remove("REPORT_CONTEXT");
        }
    }

    public static DataCacheHandler setDataSnapshot(Map<String, Object> parameters, boolean reset) {
        return DataSnapshotManager.setDataSnapshot(parameters, null, reset);
    }

    public static DataCacheHandler setDataSnapshot(Map<String, Object> parameters, DataCacheHandler cacheHandler, boolean reset) {
        SimpleReportContext reportContext = (SimpleReportContext)parameters.get("REPORT_CONTEXT");
        if (reportContext == null) {
            reportContext = new SimpleReportContext();
            parameters.put("REPORT_CONTEXT", reportContext);
        }
        if (reset) {
            reportContext.getParameterValues().remove(SAVE_SNAPSHOT);
        }
        if (cacheHandler != null) {
            reportContext.setParameterValue("net.sf.jasperreports.data.cache.handler", cacheHandler);
        } else {
            cacheHandler = (DataCacheHandler)reportContext.getParameterValue("net.sf.jasperreports.data.cache.handler");
        }
        if (cacheHandler == null || reset) {
            cacheHandler = new JSSColumnDataCacheHandler();
            reportContext.setParameterValue("net.sf.jasperreports.data.cache.handler", cacheHandler);
        }
        return cacheHandler;
    }

    public static void saveSnapshotIfExists(Map<String, Object> parameters) {
        DataCacheHandler ch;
        if (parameters == null) {
            return;
        }
        ReportContext context = (ReportContext)parameters.get("REPORT_CONTEXT");
        if (context != null && context.containsParameter("net.sf.jasperreports.data.cache.handler") && context.containsParameter(SAVE_SNAPSHOT) && (ch = (DataCacheHandler)context.getParameterValue("net.sf.jasperreports.data.cache.handler")) != null && ch.isSnapshotPopulated()) {
            String path = (String)context.getParameterValue(SAVE_SNAPSHOT);
            Date creationTimestamp = new Date();
            if (ch instanceof JSSColumnDataCacheHandler) {
                creationTimestamp = ((JSSColumnDataCacheHandler)ch).getCreationTimestamp();
            }
            DataSnapshotManager.saveSnapshot(path, creationTimestamp, ch.getDataSnapshot());
        }
    }

    public static boolean isPopulatedSnapshotExists(Map<String, Object> parameters) {
        DataCacheHandler ch;
        if (parameters == null) {
            return false;
        }
        ReportContext context = (ReportContext)parameters.get("REPORT_CONTEXT");
        return context != null && context.containsParameter("net.sf.jasperreports.data.cache.handler") && context.containsParameter(SAVE_SNAPSHOT) && (ch = (DataCacheHandler)context.getParameterValue("net.sf.jasperreports.data.cache.handler")) != null && ch.isSnapshotPopulated();
    }

    public static boolean snapshotExists(Map<String, Object> parameters) {
        ReportContext context = (ReportContext)parameters.get("REPORT_CONTEXT");
        return context != null && context.containsParameter("net.sf.jasperreports.data.cache.handler") && context.containsParameter(SAVE_SNAPSHOT);
    }

    public static boolean snapshotFileExists(Map<String, Object> parameters) {
        ReportContext context = (ReportContext)parameters.get("REPORT_CONTEXT");
        return DataSnapshotManager.snapshotExists(parameters) && context.getParameterValue(SAVE_SNAPSHOT) != null;
    }

    public static String getSnapshotFile(JasperReportsConfiguration jConfig) {
        ReportContext rc = (ReportContext)jConfig.getJRParameters().get("REPORT_CONTEXT");
        if (rc instanceof SimpleReportContext) {
            if (rc.getParameterValue(SAVE_SNAPSHOT) != null) {
                return (String)rc.getParameterValue(SAVE_SNAPSHOT);
            }
        } else if (jConfig.getProperty(SAVE_SNAPSHOT) != null) {
            return jConfig.getProperty(SAVE_SNAPSHOT);
        }
        return null;
    }

    public static void removeSnapshotFile(Map<String, Object> parameters) {
        ReportContext context = (ReportContext)parameters.get("REPORT_CONTEXT");
        if (context != null) {
            context.setParameterValue(SAVE_SNAPSHOT, null);
        }
    }

    public static void saveSnapshot(final String fname, final Date creationTimestamp, final DataSnapshot snapshot) {
        Job job = new Job("Saving snapshot to: " + fname){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Saving data snapshot to: " + fname, -1);
                try {
                    new JssDataSnapshot(creationTimestamp, snapshot);
                    if (!Misc.isNullOrEmpty((String)fname)) {
                        JRSaver.saveObject((Object)new JssDataSnapshot(creationTimestamp, snapshot), (File)new File(fname));
                    }
                }
                catch (JRException e) {
                    UIUtils.showError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void loadSnapshot(JasperReportsConfiguration jConfig, String fname) throws JRException {
        Map<String, Object> hm = jConfig.getJRParameters();
        Object obj = JRLoader.loadObject((File)new File(fname));
        if (obj instanceof JssDataSnapshot) {
            JssDataSnapshot snapshot = (JssDataSnapshot)obj;
            DataSnapshotManager.setDataSnapshot(hm, (DataCacheHandler)new JSSColumnDataCacheHandler(snapshot.getSnapshot(), snapshot.getCreationTimestamp()), false);
        } else if (obj instanceof DataSnapshot) {
            DataSnapshotManager.setDataSnapshot(hm, (DataCacheHandler)new PopulatedSnapshotCacheHandler((DataSnapshot)obj), false);
        }
        SimpleReportContext reportContext = (SimpleReportContext)hm.get("REPORT_CONTEXT");
        reportContext.setParameterValue(SAVE_SNAPSHOT, (Object)fname);
        jConfig.getMap().put(SAVE_SNAPSHOT, fname);
    }
}

