/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.PreviewContainer;
import com.jaspersoft.studio.editor.preview.input.IDataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.input.ParameterJasper;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ADataInput
implements IDataInput {
    protected Map<String, Object> params;
    protected IParameter param;
    private PropertyChangeSupport pcsupport = new PropertyChangeSupport(this);
    private static ControlDecoration errControlDeco;
    private boolean dirty = false;
    private boolean removed = false;
    protected FocusListener focusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            ADataInput.this.handleFocusLost();
        }

        public void focusGained(FocusEvent e) {
            IStatusLineManager statusLineManager = ADataInput.this.getStatusLineManager();
            if (statusLineManager != null) {
                statusLineManager.setMessage(ADataInput.this.param.getDescription());
            }
        }
    };
    protected TraverseListener keyListener = e -> {
        if (this.pcontainer != null && e.detail == 4) {
            this.pcontainer.runReport();
        }
    };
    private PreviewContainer pcontainer;
    private static int defCharWidth;
    private ControlDecoration nullDecoration;

    static {
        defCharWidth = -1;
    }

    @Override
    public void addChangeListener(PropertyChangeListener listener) {
        this.pcsupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removeChangeListener(PropertyChangeListener listener) {
        this.pcsupport.removePropertyChangeListener(listener);
    }

    @Override
    public void dispose() {
        PropertyChangeListener[] propertyChangeListenerArray = this.pcsupport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener pcl = propertyChangeListenerArray[n2];
            this.pcsupport.removePropertyChangeListener(pcl);
            ++n2;
        }
    }

    @Override
    public IDataInput getInstance() {
        try {
            return (IDataInput)this.getClass().newInstance();
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
            return null;
        }
    }

    @Override
    public IParameter getParameter() {
        return this.param;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void createInput(Composite parent, IParameter param, Map<String, Object> params) {
        this.params = params;
        this.param = param;
    }

    @Override
    public final void updateModel(Object value) {
        this.updateParameterMap(value);
        this.dirty = true;
        this.pcsupport.firePropertyChange(this.param.getName(), null, value);
    }

    protected void updateParameterMap(Object value) {
        this.params.put(this.param.getName(), value);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isLabeled() {
        return false;
    }

    protected void handleFocusLost() {
        IStatusLineManager statusLineManager = this.getStatusLineManager();
        if (statusLineManager != null) {
            statusLineManager.setMessage(null);
        }
        this.updateInput();
    }

    public static void setMandatory(IParameter prm, Control num) {
        if (prm.isMandatory()) {
            ControlDecoration controlDecoration = new ControlDecoration(num, 16512);
            controlDecoration.setDescriptionText(Messages.ADataInput_mandatory);
            controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        }
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    protected void setNullable(IParameter prm, Control num) {
        this.removed = false;
        Menu menu = new Menu(num);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.ADataInput_removeparam);
        item.addListener(13, e -> {
            this.params.remove(prm.getName());
            this.updateInput();
            this.removed = true;
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ADataInput_settonull);
        item.addListener(13, e -> {
            this.params.put(prm.getName(), null);
            this.updateInput();
        });
        num.setMenu(menu);
        this.nullDecoration = new ControlDecoration(num, 17408);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setDecoratorNullable(IParameter prm) {
        if (this.nullDecoration == null) {
            return;
        }
        if (this.params.containsKey(prm.getName())) {
            if (this.params.get(prm.getName()) != null) {
                this.nullDecoration.hide();
                return;
            }
            this.nullDecoration.setDescriptionText(Messages.ADataInput_settonull_explain);
            this.nullDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        } else {
            this.nullDecoration.setDescriptionText(Messages.ADataInput_removeparam_explain);
            this.nullDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        }
        this.nullDecoration.show();
    }

    public static void setError(Control num, String message) {
        if (errControlDeco == null) {
            errControlDeco = new ControlDecoration(num, 17408);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            errControlDeco.setImage(fieldDecoration.getImage());
        }
        errControlDeco.show();
        errControlDeco.setDescriptionText(message);
    }

    public static void hideError(Control num) {
        if (errControlDeco != null) {
            errControlDeco.hide();
        }
    }

    @Override
    public void setPcontainer(PreviewContainer pcontainer) {
        this.pcontainer = pcontainer;
    }

    protected IStatusLineManager getStatusLineManager() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        IActionBars actionBars = null;
        if (site instanceof IEditorSite) {
            actionBars = ((IEditorSite)site).getActionBars();
        } else if (site instanceof IViewSite) {
            actionBars = ((IViewSite)site).getActionBars();
        }
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    @Override
    public void parameterChanged(PropertyChangeEvent evt) {
    }

    public static int getCharWidth(Control c) {
        if (defCharWidth < 0) {
            defCharWidth = UIUtil.getCharWidth((Drawable)c);
        }
        return defCharWidth;
    }

    public JasperReportsConfiguration getjConfig() {
        if (this.param instanceof ParameterJasper) {
            return ((ParameterJasper)this.param).getjConfig();
        }
        return JasperReportsConfiguration.getDefaultInstance();
    }
}

